/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.format.support;

import org.springframework.binding.format.InvalidFormatException;
import org.springframework.binding.format.support.AbstractFormatter;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.core.enums.LabeledEnumResolver;
import org.springframework.core.enums.StaticLabeledEnumResolver;
import org.springframework.util.Assert;

public class LabeledEnumFormatter
extends AbstractFormatter {
    private LabeledEnumResolver labeledEnumResolver = StaticLabeledEnumResolver.instance();

    public LabeledEnumFormatter() {
    }

    public LabeledEnumFormatter(boolean allowEmpty) {
        super(allowEmpty);
    }

    public void setLabeledEnumResolver(LabeledEnumResolver labeledEnumResolver) {
        Assert.notNull((Object)labeledEnumResolver, (String)"The labeled enum resolver is required");
        this.labeledEnumResolver = labeledEnumResolver;
    }

    protected String doFormatValue(Object value) {
        LabeledEnum labeledEnum = (LabeledEnum)value;
        return labeledEnum.getLabel();
    }

    protected Object doParseValue(String formattedString, Class targetClass) throws IllegalArgumentException {
        LabeledEnum labeledEnum = this.labeledEnumResolver.getLabeledEnumByLabel(targetClass, formattedString);
        if (!this.isAllowEmpty()) {
            Assert.notNull((Object)labeledEnum, (String)("The label '" + formattedString + "' did not map to a valid enum instance for type " + targetClass));
            Assert.isInstanceOf((Class)targetClass, (Object)labeledEnum);
        }
        return labeledEnum;
    }

    public LabeledEnum parseLabeledEnum(String formattedString, Class enumClass) throws InvalidFormatException {
        return (LabeledEnum)this.parseValue(formattedString, enumClass);
    }
}

