/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import uk.ltd.getahead.dwr.InboundVariable;

public final class InboundContext {
    private LinkedList contexts = new LinkedList();
    private int paramCount = 0;
    private final Map variables = new HashMap();
    private final Map converted = new HashMap();

    public void pushContext(Method method, int paramNum) {
        this.contexts.addFirst(new DecodeContext(method, paramNum));
    }

    public void popContext(Method method, int paramNum) {
        DecodeContext ctx = (DecodeContext)this.contexts.removeFirst();
        if (ctx.method != method) {
            throw new IllegalArgumentException("Non-matching method");
        }
        if (ctx.paramNum != paramNum) {
            throw new IllegalArgumentException("Non-matching paramNum");
        }
    }

    public Method getCurrentMethod() {
        DecodeContext ctx = (DecodeContext)this.contexts.getFirst();
        if (ctx == null) {
            return null;
        }
        return ctx.method;
    }

    public int getCurrentParameterNum() {
        DecodeContext ctx = (DecodeContext)this.contexts.getFirst();
        if (ctx == null) {
            return -1;
        }
        return ctx.paramNum;
    }

    public void createInboundVariable(int callNum, String key, String type, String value) {
        int i;
        InboundVariable cte = new InboundVariable(this, type, value);
        this.variables.put(key, cte);
        String paramPrefix = "c" + callNum + "-" + "param";
        if (key.startsWith(paramPrefix) && (i = Integer.parseInt(key.substring(paramPrefix.length())) + 1) > this.paramCount) {
            this.paramCount = i;
        }
    }

    public InboundVariable getInboundVariable(String name) {
        return (InboundVariable)this.variables.get(name);
    }

    public void clearConverted() {
        this.converted.clear();
    }

    public void addConverted(InboundVariable iv, Object bean) {
        this.converted.put(iv, bean);
    }

    public Object getConverted(InboundVariable iv) {
        return this.converted.get(iv);
    }

    public int getParameterCount() {
        return this.paramCount;
    }

    public InboundVariable getParameter(int callNum, int index) {
        String key = "c" + callNum + "-" + "param" + index;
        return (InboundVariable)this.variables.get(key);
    }

    public Iterator getInboundVariableNames() {
        return this.variables.keySet().iterator();
    }

    static class DecodeContext {
        Method method;
        int paramNum;

        DecodeContext(Method method, int paramNum) {
            this.method = method;
            this.paramNum = paramNum;
        }
    }
}

