/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.convert;

import java.lang.reflect.Array;
import java.util.StringTokenizer;
import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.Converter;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.OutboundVariable;
import uk.ltd.getahead.dwr.util.LocalUtil;
import uk.ltd.getahead.dwr.util.Logger;

public class ArrayConverter
implements Converter {
    private static final Logger log = Logger.getLogger(class$uk$ltd$getahead$dwr$convert$ArrayConverter == null ? (class$uk$ltd$getahead$dwr$convert$ArrayConverter = ArrayConverter.class$("uk.ltd.getahead.dwr.convert.ArrayConverter")) : class$uk$ltd$getahead$dwr$convert$ArrayConverter);
    private ConverterManager converterManager = null;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$convert$ArrayConverter;

    public void setConverterManager(ConverterManager newConfig) {
        this.converterManager = newConfig;
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws ConversionException {
        if (!paramType.isArray()) {
            throw new ConversionException(Messages.getString("ArrayConverter.ClassIsNotAnArray", paramType.getName()));
        }
        String value = iv.getValue();
        if (value.startsWith("[")) {
            value = value.substring(1);
        }
        if (value.endsWith("]")) {
            value = value.substring(0, value.length() - 1);
        }
        try {
            StringTokenizer st = new StringTokenizer(value, ",");
            int size = st.countTokens();
            Class<?> componentType = paramType.getComponentType();
            Object array = Array.newInstance(componentType, size);
            inctx.addConverted(iv, array);
            InboundContext incx = iv.getLookup();
            for (int i = 0; i < size; ++i) {
                String token = st.nextToken();
                String[] split = LocalUtil.splitInbound(token);
                InboundVariable nested = new InboundVariable(incx, split[0], split[1]);
                Object output = this.converterManager.convertInbound(componentType, nested, inctx);
                Array.set(array, i, output);
            }
            return array;
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(ex);
        }
    }

    public String convertOutbound(Object data, String varname, OutboundContext outctx) throws ConversionException {
        if (!data.getClass().isArray()) {
            throw new ConversionException(Messages.getString("ArrayConverter.ClassIsNotAnArray", data.getClass().getName()));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("var ");
        buffer.append(varname);
        buffer.append(" = new Array();");
        int size = Array.getLength(data);
        for (int i = 0; i < size; ++i) {
            try {
                OutboundVariable nested = this.converterManager.convertOutbound(Array.get(data, i), outctx);
                buffer.append(nested.getInitCode());
                buffer.append(varname);
                buffer.append('[');
                buffer.append(i);
                buffer.append("] = ");
                buffer.append(nested.getAssignCode());
                buffer.append(';');
                continue;
            }
            catch (Exception ex) {
                buffer.append(varname);
                buffer.append('[');
                buffer.append(i);
                buffer.append("] = 'Conversion Error. See console log.';");
                log.warn("Failed to convert array member " + i + ". Conversion error for type: " + data.getClass().getName(), ex);
            }
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

