/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.convert;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.Converter;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.OutboundVariable;
import uk.ltd.getahead.dwr.util.LocalUtil;
import uk.ltd.getahead.dwr.util.Logger;

public class BeanConverter
implements Converter {
    private List exclusions = null;
    private List inclusions = null;
    private Class instanceType = null;
    private static final Logger log = Logger.getLogger(class$uk$ltd$getahead$dwr$convert$BeanConverter == null ? (class$uk$ltd$getahead$dwr$convert$BeanConverter = BeanConverter.class$("uk.ltd.getahead.dwr.convert.BeanConverter")) : class$uk$ltd$getahead$dwr$convert$BeanConverter);
    private ConverterManager config = null;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$convert$BeanConverter;

    public void setExclude(String excludes) {
        if (this.inclusions != null) {
            throw new IllegalArgumentException(Messages.getString("HibernateBeanConverter.OnlyIncludeOrExclude"));
        }
        this.exclusions = new ArrayList();
        String toSplit = LocalUtil.replace(excludes, ",", " ");
        StringTokenizer st = new StringTokenizer(toSplit);
        while (st.hasMoreTokens()) {
            String rule = st.nextToken();
            if (rule.startsWith("get")) {
                log.warn("Exclusions are based on property names and not method names. '" + rule + "' starts with 'get' so it looks like a method name and not a property name.");
            }
            this.exclusions.add(rule);
        }
    }

    public void setInclude(String includes) {
        if (this.exclusions != null) {
            throw new IllegalArgumentException(Messages.getString("HibernateBeanConverter.OnlyIncludeOrExclude"));
        }
        this.inclusions = new ArrayList();
        String toSplit = LocalUtil.replace(includes, ",", " ");
        StringTokenizer st = new StringTokenizer(toSplit);
        while (st.hasMoreTokens()) {
            String rule = st.nextToken();
            if (rule.startsWith("get")) {
                log.warn("Inclusions are based on property names and not method names. '" + rule + "' starts with 'get' so it looks like a method name and not a property name.");
            }
            this.inclusions.add(rule);
        }
    }

    public Class getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(Class instanceType) {
        this.instanceType = instanceType;
    }

    public void setConverterManager(ConverterManager newConfig) {
        this.config = newConfig;
    }

    public ConverterManager getConverterManager() {
        return this.config;
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws ConversionException {
        String value = iv.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("{")) {
            throw new IllegalArgumentException(Messages.getString("BeanConverter.MissingOpener", "{"));
        }
        if (!value.endsWith("}")) {
            throw new IllegalArgumentException(Messages.getString("BeanConverter.MissingCloser", "{"));
        }
        value = value.substring(1, value.length() - 1);
        try {
            Object bean = null;
            bean = this.instanceType != null ? this.instanceType.newInstance() : paramType.newInstance();
            BeanInfo info = this.getBeanInfo(bean);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            HashMap<String, PropertyDescriptor> props = new HashMap<String, PropertyDescriptor>();
            for (int i = 0; i < descriptors.length; ++i) {
                String key = descriptors[i].getName();
                props.put(key, descriptors[i]);
            }
            inctx.addConverted(iv, bean);
            StringTokenizer st = new StringTokenizer(value, ",");
            int size = st.countTokens();
            for (int i = 0; i < size; ++i) {
                String token = st.nextToken();
                if (token.trim().length() == 0) continue;
                int colonpos = token.indexOf(":");
                if (colonpos == -1) {
                    throw new ConversionException(Messages.getString("BeanConverter.MissingSeparator", ":", token));
                }
                String key = token.substring(0, colonpos).trim();
                String val = token.substring(colonpos + 1).trim();
                PropertyDescriptor descriptor = (PropertyDescriptor)props.get(key);
                Method setter = descriptor.getWriteMethod();
                if (setter == null) {
                    log.warn("No visible setter for " + key);
                    StringBuffer all = new StringBuffer();
                    Iterator it = props.keySet().iterator();
                    while (it.hasNext()) {
                        all.append(it.next());
                        if (!it.hasNext()) continue;
                        all.append(',');
                    }
                    log.warn("Setters exist for (" + all + ')');
                    continue;
                }
                Class<?> propType = descriptor.getPropertyType();
                String[] split = LocalUtil.splitInbound(val);
                InboundVariable nested = new InboundVariable(iv.getLookup(), split[0], split[1]);
                inctx.pushContext(setter, 0);
                Object output = this.config.convertInbound(propType, nested, inctx);
                inctx.popContext(setter, 0);
                setter.invoke(bean, output);
            }
            return bean;
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(ex);
        }
    }

    public String convertOutbound(Object data, String varname, OutboundContext outctx) throws ConversionException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("var ");
        buffer.append(varname);
        buffer.append(" = new Object();");
        try {
            BeanInfo info = this.getBeanInfo(data);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor descriptor = descriptors[i];
                String name = descriptor.getName();
                try {
                    Method getter = descriptor.getReadMethod();
                    if (getter == null || name.equals("class")) continue;
                    if (!this.isAllowed(name)) {
                        log.debug("Skipping marshalling " + name + " due to include/exclude rules");
                        continue;
                    }
                    if (!this.isAvailable(data, name)) {
                        log.debug("Skipping marshalling " + name + " due to availability rules");
                        continue;
                    }
                    Object value = getter.invoke(data, new Object[0]);
                    OutboundVariable nested = this.getConverterManager().convertOutbound(value, outctx);
                    buffer.append(nested.getInitCode());
                    buffer.append(varname);
                    buffer.append('.');
                    buffer.append(name);
                    buffer.append(" = ");
                    buffer.append(nested.getAssignCode());
                    buffer.append(';');
                    continue;
                }
                catch (Exception ex) {
                    log.warn("Failed to convert " + name, ex);
                }
            }
        }
        catch (IntrospectionException ex) {
            throw new ConversionException(ex);
        }
        return buffer.toString();
    }

    protected BeanInfo getBeanInfo(Object bean) throws IntrospectionException {
        BeanInfo info = Introspector.getBeanInfo(bean.getClass());
        return info;
    }

    protected boolean isAllowed(String property) {
        String test;
        Iterator it;
        if (this.exclusions != null) {
            it = this.exclusions.iterator();
            while (it.hasNext()) {
                test = (String)it.next();
                if (!property.equals(test)) continue;
                return false;
            }
        }
        if (this.inclusions != null) {
            it = this.inclusions.iterator();
            while (it.hasNext()) {
                test = (String)it.next();
                if (!property.equals(test)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isAvailable(Object data, String property) {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

