/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.Converter;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.OutboundVariable;
import uk.ltd.getahead.dwr.util.LocalUtil;
import uk.ltd.getahead.dwr.util.Logger;

public class DefaultConverterManager
implements ConverterManager {
    private Map extraTypeInfoMap = new HashMap();
    private static final Logger log = Logger.getLogger(class$uk$ltd$getahead$dwr$impl$DefaultConverterManager == null ? (class$uk$ltd$getahead$dwr$impl$DefaultConverterManager = DefaultConverterManager.class$("uk.ltd.getahead.dwr.impl.DefaultConverterManager")) : class$uk$ltd$getahead$dwr$impl$DefaultConverterManager);
    private Map converterTypes = new HashMap();
    private Map converters = new HashMap();
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$Converter;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$impl$DefaultConverterManager;

    public void addConverterType(String id, Class clazz) {
        if (!(class$uk$ltd$getahead$dwr$Converter == null ? (class$uk$ltd$getahead$dwr$Converter = DefaultConverterManager.class$("uk.ltd.getahead.dwr.Converter")) : class$uk$ltd$getahead$dwr$Converter).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(Messages.getString("DefaultConverterManager.ConverterNotAssignable", clazz, (class$uk$ltd$getahead$dwr$Converter == null ? (class$uk$ltd$getahead$dwr$Converter = DefaultConverterManager.class$("uk.ltd.getahead.dwr.Converter")) : class$uk$ltd$getahead$dwr$Converter).getName()));
        }
        try {
            clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(Messages.getString("DefaultConverterManager.ConverterNotInstantiatable", clazz.getName(), ex.toString()));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(Messages.getString("DefaultConverterManager.ConverterNotAccessable", clazz.getName(), ex.toString()));
        }
        this.converterTypes.put(id, clazz);
    }

    public void addConverter(String match, String type, Map params) throws IllegalArgumentException, InstantiationException, IllegalAccessException {
        Class clazz = (Class)this.converterTypes.get(type);
        if (clazz == null) {
            log.info("Can't marshall " + match + " because converter '" + type + "' is not available. The converter definition may be missing, or required element may be missing from the CLASSPATH");
            return;
        }
        Converter converter = (Converter)clazz.newInstance();
        converter.setConverterManager(this);
        Iterator it = params.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                LocalUtil.setProperty(converter, key, value);
            }
            catch (NoSuchMethodException ex) {
                if (key.equals("converter") || key.equals("match")) continue;
                log.debug("No property '" + key + "' on " + converter.getClass().getName());
            }
            catch (InvocationTargetException ex) {
                log.warn("Error setting " + key + "=" + value + " on " + converter.getClass().getName(), ex.getTargetException());
            }
            catch (Exception ex) {
                log.warn("Error setting " + key + "=" + value + " on " + converter.getClass().getName(), ex);
            }
        }
        Converter other = (Converter)this.converters.get(match);
        if (other != null) {
            throw new IllegalArgumentException(Messages.getString("DefaultConverterManager.DuplicateMatches", match));
        }
        this.converters.put(match, converter);
    }

    public boolean isConvertable(Class paramType) {
        return this.getConverter(paramType) != null;
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws ConversionException {
        Object converted = inctx.getConverted(iv);
        if (converted != null) {
            return converted;
        }
        Converter converter = this.getConverter(paramType);
        if (converter == null) {
            throw new ConversionException(Messages.getString("DefaultConverterManager.MissingConverter", paramType.getName()));
        }
        if (iv.isNull()) {
            return null;
        }
        return converter.convertInbound(paramType, iv, inctx);
    }

    public OutboundVariable convertOutbound(Object object, OutboundContext converted) throws ConversionException {
        if (object == null) {
            String varName = converted.getNextVariableName();
            return new OutboundVariable("var " + varName + " = null;", varName);
        }
        OutboundVariable ov = converted.get(object);
        if (ov != null) {
            return new OutboundVariable("", ov.getAssignCode());
        }
        ov = new OutboundVariable();
        String varName = converted.getNextVariableName();
        ov.setAssignCode(varName);
        converted.put(object, ov);
        Converter converter = this.getConverter(object);
        if (converter == null) {
            log.error(Messages.getString("DefaultConverterManager.MissingConverter", object.getClass().getName()));
            return new OutboundVariable("var " + varName + " = null;", varName);
        }
        ov.setInitCode(converter.convertOutbound(object, ov.getAssignCode(), converted));
        return ov;
    }

    public void setExtraTypeInfo(Method method, int paramNo, int index, Class type) {
        ParamInfoKey key = new ParamInfoKey(method, paramNo, index);
        this.extraTypeInfoMap.put(key, type);
    }

    public Class getExtraTypeInfo(Method method, int paramNo, int index) {
        ParamInfoKey key = new ParamInfoKey(method, paramNo, index);
        return (Class)this.extraTypeInfoMap.get(key);
    }

    public void setConverters(Map converters) {
        this.converters = converters;
    }

    private Converter getConverter(Object object) {
        if (object == null) {
            return this.getConverter(Void.TYPE);
        }
        return this.getConverter(object.getClass());
    }

    private Converter getConverter(Class paramType) {
        Converter converter = this.getConverterAssignableFrom(paramType);
        if (converter != null) {
            return converter;
        }
        String lookup = paramType.getName();
        if (lookup.startsWith("$Proxy") && (converter = (Converter)this.converters.get("$Proxy*")) != null) {
            return converter;
        }
        while (true) {
            if ((converter = (Converter)this.converters.get(lookup + ".*")) != null) {
                return converter;
            }
            converter = (Converter)this.converters.get(lookup + '*');
            if (converter != null) {
                return converter;
            }
            if (lookup.length() == 0) break;
            int lastdot = lookup.lastIndexOf(46);
            if (lastdot != -1) {
                lookup = lookup.substring(0, lastdot);
                continue;
            }
            int arrayMarkers = 0;
            while (lookup.charAt(arrayMarkers) == '[') {
                ++arrayMarkers;
            }
            if (arrayMarkers == 0) break;
            lookup = lookup.substring(arrayMarkers - 1, arrayMarkers + 1);
        }
        return null;
    }

    private Converter getConverterAssignableFrom(Class paramType) {
        if (paramType == null) {
            return null;
        }
        String lookup = paramType.getName();
        Converter converter = (Converter)this.converters.get(lookup);
        if (converter != null) {
            return converter;
        }
        Class<?>[] interfaces = paramType.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            converter = this.getConverterAssignableFrom(interfaces[i]);
            if (converter == null) continue;
            this.converters.put(lookup, converter);
            return converter;
        }
        converter = this.getConverterAssignableFrom(paramType.getSuperclass());
        if (converter != null) {
            this.converters.put(lookup, converter);
        }
        return converter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ParamInfoKey {
        final Method method;
        final int paramNo;
        final int index;

        ParamInfoKey(Method method, int paramNo, int index) {
            this.method = method;
            this.paramNo = paramNo;
            this.index = index;
        }

        public int hashCode() {
            return this.method.hashCode() + this.paramNo + this.index;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            ParamInfoKey that = (ParamInfoKey)obj;
            if (!this.method.equals(that.method)) {
                return false;
            }
            if (this.paramNo != that.paramNo) {
                return false;
            }
            return this.index == that.index;
        }

        public String toString() {
            return this.method.getName() + '[' + this.paramNo + "]<" + this.index + '>';
        }
    }
}

