/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.ltd.getahead.dwr.AccessControl;
import uk.ltd.getahead.dwr.Call;
import uk.ltd.getahead.dwr.Calls;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.Creator;
import uk.ltd.getahead.dwr.CreatorManager;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.Processor;
import uk.ltd.getahead.dwr.impl.ExecuteQuery;
import uk.ltd.getahead.dwr.util.JavascriptUtil;
import uk.ltd.getahead.dwr.util.LocalUtil;
import uk.ltd.getahead.dwr.util.Logger;

public class DefaultProcessor
implements Processor {
    protected static final String BLANK = "";
    protected static final String PATH_ROOT = "/";
    protected static final String PATH_EXEC = "/exec";
    protected static final String PATH_INTERFACE = "/interface/";
    protected static final String PATH_TEST = "test/";
    protected static final String PATH_UP = "..";
    protected static final String FILE_INDEX = "index.html";
    protected static final String FILE_UTIL = "util.js";
    protected static final String FILE_ENGINE = "engine.js";
    protected static final String FILE_DEPRECATED = "deprecated.js";
    protected static final String FILE_HELP = "help.html";
    protected static final String EXTENSION_JS = ".js";
    protected static final String MIME_XML = "text/xml";
    protected static final String MIME_HTML = "text/html";
    protected static final String MIME_JS = "text/javascript";
    private static final String HEADER_USER_AGENT = "User-Agent";
    private int compressionLevel = 7;
    private JavascriptUtil jsutil = new JavascriptUtil();
    private boolean allowImpossibleTests = false;
    private boolean scriptCompressed = true;
    protected CreatorManager creatorManager = null;
    protected ConverterManager converterManager = null;
    protected AccessControl accessControl = null;
    protected final Map scriptCache = new HashMap();
    private static final Logger log = Logger.getLogger(class$uk$ltd$getahead$dwr$impl$DefaultProcessor == null ? (class$uk$ltd$getahead$dwr$impl$DefaultProcessor = DefaultProcessor.class$("uk.ltd.getahead.dwr.impl.DefaultProcessor")) : class$uk$ltd$getahead$dwr$impl$DefaultProcessor);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;
    static /* synthetic */ Class class$javax$servlet$ServletConfig;
    static /* synthetic */ Class class$javax$servlet$ServletContext;
    static /* synthetic */ Class class$javax$servlet$http$HttpSession;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$impl$DefaultProcessor;

    public void handle(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pathinfo = req.getPathInfo();
        if (pathinfo == null || pathinfo.length() == 0 || pathinfo.equals(PATH_ROOT)) {
            resp.sendRedirect(req.getContextPath() + req.getServletPath() + '/' + FILE_INDEX);
        } else if (pathinfo != null && pathinfo.equalsIgnoreCase("/index.html")) {
            this.doIndex(req, resp);
        } else if (pathinfo != null && pathinfo.startsWith("/test/")) {
            this.doTest(req, resp);
        } else if (pathinfo != null && pathinfo.equalsIgnoreCase("/engine.js")) {
            this.doFile(resp, FILE_ENGINE, MIME_JS);
        } else if (pathinfo != null && pathinfo.equalsIgnoreCase("/util.js")) {
            this.doFile(resp, FILE_UTIL, MIME_JS);
        } else if (pathinfo != null && pathinfo.equalsIgnoreCase("/deprecated.js")) {
            this.doFile(resp, FILE_DEPRECATED, MIME_JS);
        } else if (pathinfo != null && pathinfo.startsWith(PATH_INTERFACE)) {
            this.doInterface(req, resp);
        } else if (pathinfo != null && pathinfo.startsWith(PATH_EXEC)) {
            this.doExec(req, resp);
        } else {
            log.warn("Page not found. In debug/test mode try viewing /[WEB-APP]/dwr/");
            resp.sendError(404);
        }
    }

    protected void doIndex(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.creatorManager.isDebug()) {
            log.warn("Failed attempt to access index page outside of debug mode. Set the debug init-parameter to true to enable.");
            resp.sendError(403);
        }
        resp.setContentType(MIME_HTML);
        PrintWriter out = resp.getWriter();
        out.println("<html>");
        out.println("<head><title>DWR Test Index</title></head>");
        out.println("<body>");
        out.println("<h2>Classes known to DWR:</h2>");
        out.println("<ul>");
        Iterator it = this.creatorManager.getCreatorNames().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Creator creator = this.creatorManager.getCreator(name);
            out.println("<li><a href='test/" + name + "'>" + name + "</a> (" + creator.getType().getName() + ")</li>");
        }
        out.println("</ul>");
        out.println("<h2>Other Links</h2>");
        out.println("<ul>");
        out.println("<li>Up to <a href='" + req.getContextPath() + "/'>top level of web app</a>.</li>");
        out.println("</ul>");
        out.println("</body></html>");
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.creatorManager.isDebug()) {
            log.warn("Failed attempt to access test pages outside of debug mode. Set the debug init-parameter to true to enable.");
            resp.sendError(403);
            return;
        }
        String scriptname = req.getPathInfo();
        scriptname = LocalUtil.replace(scriptname, "/test/", BLANK);
        scriptname = LocalUtil.replace(scriptname, PATH_ROOT, BLANK);
        Creator creator = this.creatorManager.getCreator(scriptname);
        Method[] methods = creator.getType().getMethods();
        resp.setContentType(MIME_HTML);
        PrintWriter out = resp.getWriter();
        String interfaceURL = req.getContextPath() + req.getServletPath() + PATH_INTERFACE + scriptname + EXTENSION_JS;
        String engineURL = req.getContextPath() + req.getServletPath() + '/' + FILE_ENGINE;
        String utilURL = req.getContextPath() + req.getServletPath() + '/' + FILE_UTIL;
        String proxyInterfaceURL = "../interface/" + scriptname + EXTENSION_JS;
        String proxyEngineURL = "../engine.js";
        String proxyUtilURL = "../util.js";
        out.println("<html>");
        out.println("<head>");
        out.println("  <title>DWR Test</title>");
        out.println("  <!-- These paths use .. so that they still work behind a path mapping proxy. The fully qualified version is more cut and paste friendly. -->");
        out.println("  <script type='text/javascript' src='" + proxyInterfaceURL + "'></script>");
        out.println("  <script type='text/javascript' src='" + proxyEngineURL + "'></script>");
        out.println("  <script type='text/javascript' src='" + proxyUtilURL + "'></script>");
        out.println("  <script type='text/javascript'>");
        out.println("  function objectEval(text)");
        out.println("  {");
        out.println("    // eval() breaks when we use it to get an object using the { a:42, b:'x' }");
        out.println("    // syntax because it thinks that { and } surround a block and not an object");
        out.println("    // So we wrap it in an array and extract the first element to get around");
        out.println("    // this.");
        out.println("    // The regex = [start of line][whitespace]{[stuff]}[whitespace][end of line]");
        out.println("    text = text.replace(/\\n/g, ' ');");
        out.println("    text = text.replace(/\\r/g, ' ');");
        out.println("    if (text.match(/^\\s*\\{.*\\}\\s*$/))");
        out.println("    {");
        out.println("      text = '[' + text + '][0]';");
        out.println("    }");
        out.println("    return eval(text);");
        out.println("  }");
        out.println("  </script>");
        out.println("  <style>");
        out.println("    input.itext { font-size: smaller; background: #E4E4E4; border: 0; }");
        out.println("    input.ibutton { font-size: xx-small; border: 1px outset; margin: 0px; padding: 0px; }");
        out.println("    span.reply { background: #ffffdd; white-space: pre; }");
        out.println("    span.warning { font-size: smaller; color: red; }");
        out.println("  </style>");
        out.println("</head>");
        out.println("<body onload='DWRUtil.useLoadingMessage()'>");
        out.println(BLANK);
        out.println("<h2>Methods For: " + scriptname + " (" + creator.getType().getName() + ")</h2>");
        out.println("<p>To use this class in your javascript you will need the following script includes:</p>");
        out.println("<pre>");
        out.println("  &lt;script type='text/javascript' src='<a href='" + interfaceURL + "'>" + interfaceURL + "</a>'&gt;&lt;/script&gt;");
        out.println("  &lt;script type='text/javascript' src='<a href='" + engineURL + "'>" + engineURL + "</a>'&gt;&lt;/script&gt;");
        out.println("</pre>");
        out.println("<p>In addition there is an optional utility script:</p>");
        out.println("<pre>");
        out.println("  &lt;script type='text/javascript' src='<a href='" + utilURL + "'>" + utilURL + "</a>'&gt;&lt;/script&gt;");
        out.println("</pre>");
        out.println("<p>Replies from DWR are shown with a yellow background if they are simple or in an alert box otherwise.<br/>");
        out.println("The inputs are evaluated as Javascript so strings must be quoted before execution.</p>");
        out.println("<p>There are " + methods.length + " declared methods:</p><ul>");
        for (int i = 0; i < methods.length; ++i) {
            String warning;
            int j;
            Method method = methods[i];
            String methodName = method.getName();
            String reason = this.accessControl.getReasonToNotDisplay(req, creator, scriptname, method);
            if (reason != null) {
                out.println(BLANK);
                out.println("<li style='color: #A88;'>  " + methodName + "() is not available: " + reason + "</li>");
                if (!this.allowImpossibleTests) continue;
            }
            if (this.jsutil.isReservedWord(methodName)) {
                out.println(BLANK);
                out.println("<li style='color: #88A;'>" + methodName + "() is not available because it is a reserved word.</li>");
                continue;
            }
            out.println(BLANK);
            out.println("<li>");
            out.println("  " + methodName + '(');
            Class<?>[] paramTypes = method.getParameterTypes();
            for (int j2 = 0; j2 < paramTypes.length; ++j2) {
                Class<?> paramType = paramTypes[j2];
                if (this.isAutoFilled(paramType)) {
                    out.print("AUTO");
                } else {
                    String value = BLANK;
                    if (paramType == (class$java$lang$String == null ? DefaultProcessor.class$("java.lang.String") : class$java$lang$String)) {
                        value = "\"\"";
                    } else if (paramType == (class$java$lang$Boolean == null ? DefaultProcessor.class$("java.lang.Boolean") : class$java$lang$Boolean) || paramType == Boolean.TYPE) {
                        value = "true";
                    } else if (paramType == (class$java$lang$Integer == null ? DefaultProcessor.class$("java.lang.Integer") : class$java$lang$Integer) || paramType == Integer.TYPE || paramType == (class$java$lang$Short == null ? DefaultProcessor.class$("java.lang.Short") : class$java$lang$Short) || paramType == Short.TYPE || paramType == (class$java$lang$Long == null ? DefaultProcessor.class$("java.lang.Long") : class$java$lang$Long) || paramType == Long.TYPE || paramType == (class$java$lang$Byte == null ? DefaultProcessor.class$("java.lang.Byte") : class$java$lang$Byte) || paramType == Byte.TYPE) {
                        value = "0";
                    } else if (paramType == (class$java$lang$Float == null ? DefaultProcessor.class$("java.lang.Float") : class$java$lang$Float) || paramType == Float.TYPE || paramType == (class$java$lang$Double == null ? DefaultProcessor.class$("java.lang.Double") : class$java$lang$Double) || paramType == Double.TYPE) {
                        value = "0.0";
                    } else if (paramType.isArray() || (class$java$util$Collection == null ? DefaultProcessor.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(paramType)) {
                        value = "[]";
                    } else if ((class$java$util$Map == null ? DefaultProcessor.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(paramType)) {
                        value = "{}";
                    }
                    out.print("    <input class='itext' type='text' size='10' value='" + value + "' id='p" + i + j2 + "' title='Will be converted to: " + paramType.getName() + "'/>");
                }
                out.println(j2 == paramTypes.length - 1 ? BLANK : ", ");
            }
            out.println("  );");
            String onclick = scriptname + '.' + methodName + "(reply" + i;
            for (int j3 = 0; j3 < paramTypes.length; ++j3) {
                if (this.isAutoFilled(paramTypes[j3])) continue;
                onclick = onclick + ",objectEval($(\"p" + i + j3 + "\").value)";
            }
            onclick = onclick + ");";
            out.println("  <input class='ibutton' type='button' onclick='" + onclick + "' value='Execute'  title='Calls " + scriptname + '.' + methodName + "(). View source for details.'/>");
            out.println("  <script type='text/javascript'>");
            out.println("    var reply" + i + " = function(data)");
            out.println("    {");
            out.println("      if (data != null && typeof data == 'object') alert(DWRUtil.toDescriptiveString(data, 2));");
            out.println("      else DWRUtil.setValue('d" + i + "', DWRUtil.toDescriptiveString(data, 1));");
            out.println("    }");
            out.println("  </script>");
            out.println("  <span id='d" + i + "' class='reply'></span>");
            boolean overloaded = false;
            for (j = 0; j < methods.length; ++j) {
                if (j == i || !methods[j].getName().equals(methodName)) continue;
                overloaded = true;
            }
            if (overloaded) {
                out.println("<br/><span class='warning'>(Warning: overloaded methods are not recommended. See <a href='#overloadedMethod'>below</a>)</span>");
            }
            for (j = 0; j < paramTypes.length; ++j) {
                if (this.converterManager.isConvertable(paramTypes[j])) continue;
                out.println("<br/><span class='warning'>(Warning: No Converter for " + paramTypes[j].getName() + ". See <a href='#missingConverter'>below</a>)</span>");
            }
            if (!this.converterManager.isConvertable(method.getReturnType())) {
                out.println("<br/><span class='warning'>(Warning: No Converter for " + method.getReturnType().getName() + ". See <a href='#missingConverter'>below</a>)</span>");
            }
            if ((warning = this.accessControl.getReasonToNotExecute(req, creator, scriptname, method)) != null) {
                out.println("<br/><span class='warning'>(Warning: Role restructions in place: " + warning + ".)</span>");
            }
            out.println("</li>");
        }
        out.println(BLANK);
        out.println("</ul>");
        out.println("<h2>Other Links</h2>");
        out.println("<ul>");
        out.println("<li>Back to <a href='" + req.getContextPath() + req.getServletPath() + "'>class index</a>.</li>");
        out.println("<li>Up to <a href='" + req.getContextPath() + "/'>top level of web app</a>.</li>");
        out.println("</ul>");
        Map map = this.scriptCache;
        synchronized (map) {
            String output = (String)this.scriptCache.get(FILE_HELP);
            if (output == null) {
                StringBuffer buffer = new StringBuffer();
                InputStream raw = this.getClass().getResourceAsStream("/uk/ltd/getahead/dwr/help.html");
                if (raw == null) {
                    log.error(Messages.getString("DefaultProcessor.MissingHelp", FILE_HELP));
                    output = "<p>Failed to read help text from resource file. Check dwr.jar is built to include html files.</p>";
                } else {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader(raw));
                    while ((line = in.readLine()) != null) {
                        buffer.append(line);
                        buffer.append('\n');
                    }
                    output = buffer.toString();
                }
                this.scriptCache.put(FILE_HELP, output);
            }
            out.println(output);
        }
        out.println("</body></html>");
        out.flush();
    }

    protected void doInterface(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String scriptname = req.getPathInfo();
        scriptname = LocalUtil.replace(scriptname, PATH_INTERFACE, BLANK);
        scriptname = LocalUtil.replace(scriptname, EXTENSION_JS, BLANK);
        Creator creator = this.creatorManager.getCreator(scriptname);
        PrintWriter out = resp.getWriter();
        out.println();
        out.println("function " + scriptname + "() { }");
        out.println();
        Method[] methods = creator.getType().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            String reason = this.accessControl.getReasonToNotDisplay(req, creator, scriptname, method);
            if (reason != null && !this.allowImpossibleTests || this.jsutil.isReservedWord(methodName)) continue;
            if (i != 0) {
                out.print('\n');
            }
            out.print(scriptname + '.' + methodName + " = function(");
            Class<?>[] paramTypes = method.getParameterTypes();
            for (int j = 0; j < paramTypes.length; ++j) {
                if (this.isAutoFilled(paramTypes[j])) continue;
                out.print("p" + j + ", ");
            }
            out.println("callback)");
            out.println('{');
            String path = req.getContextPath() + req.getServletPath();
            out.print("    DWREngine._execute('" + path + "', '" + scriptname + "', '" + methodName + "', ");
            for (int j = 0; j < paramTypes.length; ++j) {
                if (this.isAutoFilled(paramTypes[j])) {
                    out.print("false, ");
                    continue;
                }
                out.print("p" + j + ", ");
            }
            out.println("callback);");
            out.println('}');
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFile(HttpServletResponse resp, String path, String mimeType) throws IOException {
        resp.setContentType(mimeType);
        String output = null;
        Map map = this.scriptCache;
        synchronized (map) {
            output = (String)this.scriptCache.get(path);
            if (output == null) {
                String line;
                StringBuffer buffer = new StringBuffer();
                InputStream raw = this.getClass().getResourceAsStream("/uk/ltd/getahead/dwr/" + path);
                BufferedReader in = new BufferedReader(new InputStreamReader(raw));
                while ((line = in.readLine()) != null) {
                    buffer.append(line);
                    buffer.append('\n');
                }
                output = buffer.toString();
                if (mimeType.equals(MIME_JS) && this.scriptCompressed) {
                    output = this.jsutil.compress(output, this.compressionLevel);
                }
                this.scriptCache.put(path, output);
            }
        }
        PrintWriter out = resp.getWriter();
        out.println(output);
        out.flush();
    }

    protected void doExec(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String prefix;
            Calls calls;
            ExecuteQuery eq = new ExecuteQuery(this.creatorManager, this.converterManager, this.accessControl);
            try {
                calls = eq.execute(req);
            }
            catch (Exception ex) {
                if (log.isDebugEnabled()) {
                    String line;
                    ex.printStackTrace();
                    log.debug("Parse error: " + ex);
                    log.debug("- User Agent: " + req.getHeader(HEADER_USER_AGENT));
                    log.debug("- Remote IP:  " + req.getRemoteAddr());
                    log.debug("- Request URL:" + req.getRequestURL());
                    log.debug("- Query:      " + req.getQueryString());
                    log.debug("- Method:     " + req.getMethod());
                    log.debug("- Body: {");
                    BufferedReader in = req.getReader();
                    for (int lines = 0; in != null && lines < 100 && (line = in.readLine()) != null; ++lines) {
                        log.debug("-   " + line);
                    }
                    log.debug("- }" + req.getMethod());
                }
                resp.setContentType(MIME_HTML);
                PrintWriter out = resp.getWriter();
                out.println("//<script type='text/javascript'>");
                out.println("DWREngine._handleWarning('Your browser sent a request that could not be understood.\\nIf you understand how Javascript works in your browser, please help us fix the problem.\\nSee the mailing lists at http://www.getahead.ltd.uk/dwr/ for more information.');");
                out.println("//</script>");
                out.flush();
                return;
            }
            for (int i = 0; i < calls.getCallCount(); ++i) {
                Call call = calls.getCall(i);
                if (call.getThrowable() != null) {
                    log.warn("Erroring: id[" + call.getId() + "] message[" + call.getThrowable().toString() + ']');
                    continue;
                }
                log.debug("Returning: id[" + call.getId() + "] init[" + call.getReply().getInitCode() + "] assign[" + call.getReply().getAssignCode() + "] xhr[" + calls.isXhrMode() + ']');
            }
            StringBuffer buffer = new StringBuffer();
            String string = prefix = calls.isXhrMode() ? BLANK : "window.parent.";
            if (!calls.isXhrMode()) {
                buffer.append("<script type='text/javascript'>\n");
            }
            for (int i = 0; i < calls.getCallCount(); ++i) {
                Call call = calls.getCall(i);
                if (call.getThrowable() != null) {
                    String output = this.jsutil.escapeJavaScript(call.getThrowable().toString());
                    buffer.append(prefix);
                    buffer.append("DWREngine._handleError('");
                    buffer.append(call.getId());
                    buffer.append("', '");
                    buffer.append(output);
                    buffer.append("');\n");
                    continue;
                }
                buffer.append(call.getReply().getInitCode());
                buffer.append('\n');
                buffer.append(prefix);
                buffer.append("DWREngine._handleResponse('");
                buffer.append(call.getId());
                buffer.append("', ");
                buffer.append(call.getReply().getAssignCode());
                buffer.append(");\n");
            }
            if (!calls.isXhrMode()) {
                buffer.append("</script>\n");
            }
            String reply = buffer.toString();
            log.debug(reply);
            resp.setContentType(calls.isXhrMode() ? MIME_XML : MIME_HTML);
            PrintWriter out = resp.getWriter();
            out.print(reply);
            out.flush();
        }
        catch (Exception ex) {
            log.error("Failure in doExec()", ex);
            resp.sendError(500);
        }
    }

    private boolean isAutoFilled(Class paramType) {
        return paramType == (class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = DefaultProcessor.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest) || paramType == (class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = DefaultProcessor.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse) || paramType == (class$javax$servlet$ServletConfig == null ? (class$javax$servlet$ServletConfig = DefaultProcessor.class$("javax.servlet.ServletConfig")) : class$javax$servlet$ServletConfig) || paramType == (class$javax$servlet$ServletContext == null ? (class$javax$servlet$ServletContext = DefaultProcessor.class$("javax.servlet.ServletContext")) : class$javax$servlet$ServletContext) || paramType == (class$javax$servlet$http$HttpSession == null ? (class$javax$servlet$http$HttpSession = DefaultProcessor.class$("javax.servlet.http.HttpSession")) : class$javax$servlet$http$HttpSession);
    }

    public boolean isAllowImpossibleTests() {
        return this.allowImpossibleTests;
    }

    public void setAllowImpossibleTests(boolean allowImpossibleTests) {
        this.allowImpossibleTests = allowImpossibleTests;
    }

    public void setCreatorManager(CreatorManager creatorManager) {
        this.creatorManager = creatorManager;
    }

    public CreatorManager getCreatorManager() {
        return this.creatorManager;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public ConverterManager getConverterManager() {
        return this.converterManager;
    }

    public boolean isScriptCompressed() {
        return this.scriptCompressed;
    }

    public void setScriptCompressed(boolean scriptCompressed) {
        this.scriptCompressed = scriptCompressed;
    }

    public AccessControl getAccessControl() {
        return this.accessControl;
    }

    public void setAccessControl(AccessControl accessControl) {
        this.accessControl = accessControl;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

