/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.annotation;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.annotation.AnnotationBeanUtils;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedNotification;
import org.springframework.jmx.export.annotation.ManagedNotifications;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.metadata.InvalidMetadataException;
import org.springframework.jmx.export.metadata.JmxAttributeSource;

public class AnnotationJmxAttributeSource
implements JmxAttributeSource {
    public org.springframework.jmx.export.metadata.ManagedResource getManagedResource(Class beanClass) throws InvalidMetadataException {
        ManagedResource ann = beanClass.getAnnotation(ManagedResource.class);
        if (ann == null) {
            return null;
        }
        org.springframework.jmx.export.metadata.ManagedResource managedResource = new org.springframework.jmx.export.metadata.ManagedResource();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)managedResource, (String[])new String[0]);
        return managedResource;
    }

    public org.springframework.jmx.export.metadata.ManagedAttribute getManagedAttribute(Method method) throws InvalidMetadataException {
        ManagedAttribute ann = method.getAnnotation(ManagedAttribute.class);
        if (ann == null) {
            return null;
        }
        org.springframework.jmx.export.metadata.ManagedAttribute managedAttribute = new org.springframework.jmx.export.metadata.ManagedAttribute();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)managedAttribute, (String[])new String[]{"defaultValue"});
        if (ann.defaultValue().length() > 0) {
            managedAttribute.setDefaultValue(ann.defaultValue());
        }
        return managedAttribute;
    }

    public org.springframework.jmx.export.metadata.ManagedOperation getManagedOperation(Method method) throws InvalidMetadataException {
        PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)method);
        if (pd != null) {
            throw new InvalidMetadataException("The ManagedOperation attribute is not valid for JavaBean properties. Use ManagedAttribute instead.");
        }
        ManagedOperation ann = method.getAnnotation(ManagedOperation.class);
        if (ann == null) {
            return null;
        }
        org.springframework.jmx.export.metadata.ManagedOperation op = new org.springframework.jmx.export.metadata.ManagedOperation();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)op, (String[])new String[0]);
        return op;
    }

    public org.springframework.jmx.export.metadata.ManagedOperationParameter[] getManagedOperationParameters(Method method) throws InvalidMetadataException {
        ManagedOperationParameters params = method.getAnnotation(ManagedOperationParameters.class);
        org.springframework.jmx.export.metadata.ManagedOperationParameter[] result = null;
        if (params == null) {
            result = new org.springframework.jmx.export.metadata.ManagedOperationParameter[]{};
        } else {
            ManagedOperationParameter[] paramData = params.value();
            result = new org.springframework.jmx.export.metadata.ManagedOperationParameter[paramData.length];
            for (int i = 0; i < paramData.length; ++i) {
                ManagedOperationParameter annotation = paramData[i];
                org.springframework.jmx.export.metadata.ManagedOperationParameter managedOperationParameter = new org.springframework.jmx.export.metadata.ManagedOperationParameter();
                AnnotationBeanUtils.copyPropertiesToBean((Annotation)annotation, (Object)managedOperationParameter, (String[])new String[0]);
                result[i] = managedOperationParameter;
            }
        }
        return result;
    }

    public org.springframework.jmx.export.metadata.ManagedNotification[] getManagedNotifications(Class clazz) throws InvalidMetadataException {
        ManagedNotifications notificationsAnn = clazz.getAnnotation(ManagedNotifications.class);
        if (notificationsAnn == null) {
            return new org.springframework.jmx.export.metadata.ManagedNotification[0];
        }
        ManagedNotification[] notifications = notificationsAnn.value();
        org.springframework.jmx.export.metadata.ManagedNotification[] result = new org.springframework.jmx.export.metadata.ManagedNotification[notifications.length];
        for (int i = 0; i < notifications.length; ++i) {
            ManagedNotification notification = notifications[i];
            org.springframework.jmx.export.metadata.ManagedNotification managedNotification = new org.springframework.jmx.export.metadata.ManagedNotification();
            AnnotationBeanUtils.copyPropertiesToBean((Annotation)notification, (Object)managedNotification, (String[])new String[0]);
            result[i] = managedNotification;
        }
        return result;
    }
}

