/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.commonj;

import commonj.work.Work;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.util.Assert;

public class DelegatingWork
implements Work {
    private final Runnable runnable;

    public DelegatingWork(Runnable work) {
        Assert.notNull((Object)work, (String)"Runnable is required");
        this.runnable = work;
    }

    public void run() {
        this.runnable.run();
    }

    public boolean isDaemon() {
        if (this.runnable instanceof SchedulingAwareRunnable) {
            return ((SchedulingAwareRunnable)this.runnable).isLongLived();
        }
        return false;
    }

    public void release() {
    }
}

