/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.format.support;

import java.text.ParseException;
import org.springframework.binding.format.Formatter;
import org.springframework.binding.format.InvalidFormatException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractFormatter
implements Formatter {
    private boolean allowEmpty = true;

    protected AbstractFormatter() {
    }

    protected AbstractFormatter(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public final String formatValue(Object value) {
        if (this.allowEmpty && this.isEmpty(value)) {
            return this.getEmptyFormattedValue();
        }
        Assert.isTrue((!this.isEmpty(value) ? 1 : 0) != 0, (String)"Object to format cannot be empty");
        return this.doFormatValue(value);
    }

    protected abstract String doFormatValue(Object var1);

    protected String getEmptyFormattedValue() {
        return "";
    }

    public final Object parseValue(String formattedString, Class targetClass) throws InvalidFormatException {
        try {
            if (this.allowEmpty && this.isEmpty(formattedString)) {
                return this.getEmptyValue();
            }
            return this.doParseValue(formattedString, targetClass);
        }
        catch (ParseException ex) {
            throw new InvalidFormatException(formattedString, this.getExpectedFormat(targetClass), ex);
        }
    }

    protected Object getEmptyValue() {
        return null;
    }

    protected String getExpectedFormat(Class targetClass) {
        return null;
    }

    protected abstract Object doParseValue(String var1, Class var2) throws InvalidFormatException, ParseException;

    protected boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            return !StringUtils.hasText((String)((String)o));
        }
        return false;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }
}

