/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.AccumulateMonitor;
import com.jamonapi.AccumulateMonitorInterface;
import com.jamonapi.Counter;
import java.util.ArrayList;

public class TimeStatsDistMonitor
extends AccumulateMonitor {
    static Counter allActive = new Counter();
    static Counter primaryActive = new Counter();
    int active;
    private static final int i10 = 0;
    private static final int i20 = 1;
    private static final int i40 = 2;
    private static final int i80 = 3;
    private static final int i160 = 4;
    private static final int i320 = 5;
    private static final int i640 = 6;
    private static final int i1280 = 7;
    private static final int i2560 = 8;
    private static final int i5120 = 9;
    private static final int i10240 = 10;
    private static final int i20480 = 11;
    private static final int iLAST_GROUP = 12;
    private static final int DIST_SIZE = 13;
    private FrequencyDist[] dist;

    public TimeStatsDistMonitor() {
        this.populateDist();
    }

    public TimeStatsDistMonitor(AccumulateMonitorInterface accumulateMonitorInterface) {
        super(accumulateMonitorInterface);
        this.populateDist();
    }

    protected synchronized void increaseThis(long l) {
        this.distribution(l);
    }

    protected synchronized void startThis() {
        allActive.increment();
        if (this.isPrimary()) {
            primaryActive.increment();
        }
        ++this.active;
    }

    protected synchronized void stopThis() {
        if (this.active > 0) {
            --this.active;
        }
        if (this.isPrimary()) {
            primaryActive.decrement();
        }
        allActive.decrement();
    }

    private void populateDist() {
        this.dist = new FrequencyDist[13];
        int n = 0;
        while (n < 13) {
            this.dist[n] = new FrequencyDist();
            ++n;
        }
    }

    private void distribution(long l) {
        if (l < 0L) {
            throw new RuntimeException("Value passed to TimeStatsMonitor.distribution(value) must be positive. It was=" + l);
        }
        this.getDist(l).increment(l);
    }

    private FrequencyDist getDist(long l) {
        if (l <= (long)10) {
            return this.dist[0];
        }
        if (l <= (long)20) {
            return this.dist[1];
        }
        if (l <= (long)40) {
            return this.dist[2];
        }
        if (l <= (long)80) {
            return this.dist[3];
        }
        if (l <= (long)160) {
            return this.dist[4];
        }
        if (l <= (long)320) {
            return this.dist[5];
        }
        if (l <= (long)640) {
            return this.dist[6];
        }
        if (l <= (long)1280) {
            return this.dist[7];
        }
        if (l <= (long)2560) {
            return this.dist[8];
        }
        if (l <= (long)5120) {
            return this.dist[9];
        }
        if (l <= (long)10240) {
            return this.dist[10];
        }
        if (l <= (long)20480) {
            return this.dist[11];
        }
        return this.dist[12];
    }

    protected synchronized void resetThis() {
        this.populateDist();
    }

    protected synchronized String toStringThis() {
        return "";
    }

    protected synchronized void getDataThis(ArrayList arrayList) {
        arrayList.add(this.isPrimary() ? "Yes" : "&nbsp");
        int n = 0;
        while (n < 13) {
            arrayList.add(this.dist[n].toString());
            ++n;
        }
    }

    protected void getHeaderThis(ArrayList arrayList) {
        arrayList.add("Primary");
        arrayList.add("0-10ms.");
        arrayList.add("11-20ms.");
        arrayList.add("21-40ms.");
        arrayList.add("41-80ms.");
        arrayList.add("81-160ms.");
        arrayList.add("161-320ms.");
        arrayList.add("321-640ms.");
        arrayList.add("641-1280ms.");
        arrayList.add("1281-2560ms.");
        arrayList.add("2561-5120ms.");
        arrayList.add("5121-10240ms.");
        arrayList.add("10241-20480ms.");
        arrayList.add(">20480ms.");
    }

    public static void main(String[] stringArray) throws Exception {
        TimeStatsDistMonitor timeStatsDistMonitor = new TimeStatsDistMonitor();
        System.out.println("There should be 1 entry for each distribution range");
        System.out.println("All entries should have 5/low value of range/3");
        timeStatsDistMonitor.start();
        timeStatsDistMonitor.start();
        timeStatsDistMonitor.start();
        int n = 1;
        while (n <= 5) {
            timeStatsDistMonitor.increase(0L);
            timeStatsDistMonitor.increase(20);
            timeStatsDistMonitor.increase(40);
            timeStatsDistMonitor.increase(80);
            timeStatsDistMonitor.increase(160);
            timeStatsDistMonitor.increase(320);
            timeStatsDistMonitor.increase(640);
            timeStatsDistMonitor.increase(1280);
            timeStatsDistMonitor.increase(2560);
            timeStatsDistMonitor.increase(5120);
            timeStatsDistMonitor.increase(10240);
            timeStatsDistMonitor.increase(20480);
            timeStatsDistMonitor.increase(50000L);
            ++n;
        }
        timeStatsDistMonitor.stop();
        timeStatsDistMonitor.stop();
        timeStatsDistMonitor.stop();
        ArrayList arrayList = new ArrayList();
        timeStatsDistMonitor.getData(arrayList);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            System.out.println("distribution index " + n2 + "=" + arrayList.get(n2));
            ++n2;
        }
    }

    final class FrequencyDist {
        private int hits;
        private long totalTime;
        private long allActiveTotal;
        private long primaryActiveTotal;
        private int activeTotal;

        final void increment(long l) {
            ++this.hits;
            this.totalTime += l;
            this.allActiveTotal += (long)TimeStatsDistMonitor.allActive.count;
            this.primaryActiveTotal += (long)TimeStatsDistMonitor.primaryActive.count;
            this.activeTotal += TimeStatsDistMonitor.this.active;
        }

        private final float avgTotalActive() {
            if (this.hits == 0) {
                return 0.0f;
            }
            return (float)this.allActiveTotal / (float)this.hits;
        }

        private final float avgActive() {
            if (this.hits == 0) {
                return 0.0f;
            }
            return (float)this.activeTotal / (float)this.hits;
        }

        private final float avgPrimaryActive() {
            if (this.hits == 0) {
                return 0.0f;
            }
            return (float)this.primaryActiveTotal / (float)this.hits;
        }

        private final long avgTime() {
            if (this.hits == 0) {
                return 0L;
            }
            return this.totalTime / (long)this.hits;
        }

        public final String toString() {
            if (this.hits == 0) {
                return "&nbsp";
            }
            return String.valueOf(AccumulateMonitor.convertToString(this.hits)) + "/" + AccumulateMonitor.convertToString(this.avgTime()) + "&nbsp" + "(" + AccumulateMonitor.convertToString(this.avgActive()) + "/" + AccumulateMonitor.convertToString(this.avgPrimaryActive()) + "/" + AccumulateMonitor.convertToString(this.avgTotalActive()) + ")";
        }

        FrequencyDist() {
        }
    }
}

