/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.AccumulateMonitorInterface;
import com.jamonapi.BaseMonitor;
import com.jamonapi.Monitor;
import com.jamonapi.NullAccumulateMonitor;
import com.jamonapi.utils.LeafNode;
import java.util.ArrayList;

public class TimingMonitor
extends BaseMonitor
implements LeafNode {
    private long startTime;
    AccumulateMonitorInterface childMonitor;
    boolean isRunningFlag = true;
    long accrued;
    boolean hasChildren;
    private boolean primary;

    TimingMonitor() {
        this(NullAccumulateMonitor.createInstance());
        this.hasChildren = false;
    }

    TimingMonitor(AccumulateMonitorInterface accumulateMonitorInterface) {
        this.childMonitor = accumulateMonitorInterface;
        this.hasChildren = true;
    }

    public long getAccrued() {
        return this.accrued + this.timeElapsedSinceLastStart();
    }

    private long timeElapsedSinceLastStart() {
        if (this.isRunning()) {
            return System.currentTimeMillis() - this.startTime;
        }
        return 0L;
    }

    public void reset() {
        this.accrued = 0L;
        this.resetStartTime();
    }

    public void increase(long l) {
        if (this.isRunning()) {
            this.childMonitor.increase(l);
            this.accrued += l;
        }
    }

    public Monitor start() {
        TimingMonitor timingMonitor = new TimingMonitor(this.childMonitor);
        timingMonitor.resetStartTime();
        timingMonitor.hasChildren = this.hasChildren;
        timingMonitor.childMonitor.start();
        return timingMonitor;
    }

    public void getData(ArrayList arrayList) {
        this.childMonitor.getData(arrayList);
    }

    public void getHeader(ArrayList arrayList) {
        this.childMonitor.getHeader(arrayList);
    }

    public Monitor stop() {
        this.increase(this.timeElapsedSinceLastStart());
        if (this.isRunning()) {
            this.childMonitor.stop();
        }
        this.setRunning(false);
        return this;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean bl) {
        this.primary = bl;
        this.childMonitor.setPrimary(bl);
    }

    private boolean isRunning() {
        return this.isRunningFlag;
    }

    private void resetStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    public String toString() {
        String string = String.valueOf(this.getAccruedString()) + " ms.";
        if (this.hasChildren) {
            string = String.valueOf(string) + (" (" + this.childMonitor.toString() + ")");
        }
        return string;
    }

    private void setRunning(boolean bl) {
        this.isRunningFlag = bl;
    }

    public static void main(String[] stringArray) throws Exception {
        Monitor monitor = new TimingMonitor();
        monitor = monitor.start();
        Thread.sleep(1000);
        monitor.stop();
        System.out.println("should be about 1000=" + monitor.getAccrued());
        System.out.println("should be same as above " + monitor.getAccrued());
        Thread.sleep(1000);
        System.out.println("should be same as above " + monitor.getAccrued());
        monitor.reset();
        Thread.sleep(10);
        System.out.println("should be 0=" + monitor.getAccrued());
        monitor = monitor.start();
        Thread.sleep(100);
        System.out.println("should be about 100=" + monitor.getAccrued());
        monitor = monitor.start();
        Thread.sleep(500);
        monitor.stop();
        monitor = monitor.start();
        Thread.sleep(250);
        System.out.println("should be about 250=" + monitor.getAccrued());
        monitor = monitor.start();
        Thread.sleep(500);
        Thread.sleep(250);
        System.out.println("should be about 750=" + monitor.getAccrued());
        System.out.println("toString should be about 750=" + monitor.stop());
        Thread.sleep(250);
        System.out.println("toString should be about 750=" + monitor.stop());
        int n = 1;
        while (n <= 5) {
            monitor = monitor.start();
            Thread.sleep(n * 10);
            monitor.stop();
            ++n;
        }
        System.out.println("\ntesting start() and stop() in loop.  should be about 50=" + monitor);
        monitor.reset();
        System.out.println("\nreset to 0's: " + monitor);
    }
}

