/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.List;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.markup.MarkupParser;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class Cell
extends Rectangle
implements TextElementArray {
    protected ArrayList arrayList = null;
    protected int horizontalAlignment = -1;
    protected int verticalAlignment = -1;
    protected String width;
    protected int colspan = 1;
    protected int rowspan = 1;
    float leading = Float.NaN;
    protected boolean header;
    protected boolean useAscender = false;
    protected boolean useDescender = false;
    protected boolean useBorderPadding;
    protected boolean groupChange = true;
    protected int maxLines = Integer.MAX_VALUE;
    String showTruncation;

    public static Cell getDummyCell() {
        Cell cell = new Cell(true);
        cell.setColspan(3);
        cell.setBorder(0);
        return cell;
    }

    public Cell() {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(-1);
        this.setBorderWidth(0.5f);
        this.arrayList = new ArrayList();
    }

    public Cell(boolean bl) {
        this();
        this.arrayList.add(new Paragraph(0.0f));
    }

    public Cell(String string) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(-1);
        this.setBorderWidth(0.5f);
        this.arrayList = new ArrayList();
        try {
            this.addElement(new Paragraph(string));
        }
        catch (BadElementException badElementException) {
            // empty catch block
        }
    }

    public Cell(Element element) throws BadElementException {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(-1);
        this.setBorderWidth(0.5f);
        if (element instanceof Phrase) {
            Phrase phrase = (Phrase)element;
            this.leading = phrase.leading();
        }
        this.arrayList = new ArrayList();
        this.addElement(element);
    }

    public Cell(Properties properties) {
        this();
        int n;
        int n2;
        int n3;
        String string = (String)properties.remove("horizontalalign");
        if (string != null) {
            this.setHorizontalAlignment(string);
        }
        if ((string = (String)properties.remove("verticalalign")) != null) {
            this.setVerticalAlignment(string);
        }
        if ((string = (String)properties.remove("width")) != null) {
            this.setWidth(string);
        }
        if ((string = (String)properties.remove("colspan")) != null) {
            this.setColspan(Integer.parseInt(string));
        }
        if ((string = (String)properties.remove("rowspan")) != null) {
            this.setRowspan(Integer.parseInt(string));
        }
        if ((string = (String)properties.remove("leading")) != null) {
            this.setLeading(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)properties.remove("header")) != null) {
            this.setHeader(new Boolean(string));
        }
        if ((string = (String)properties.remove("nowrap")) != null) {
            this.setNoWrap(new Boolean(string));
        }
        if ((string = (String)properties.remove("borderwidth")) != null) {
            this.setBorderWidth(Float.valueOf(string + "f").floatValue());
        }
        int n4 = 0;
        string = (String)properties.remove("left");
        if (string != null && new Boolean(string).booleanValue()) {
            n4 |= 4;
        }
        if ((string = (String)properties.remove("right")) != null && new Boolean(string).booleanValue()) {
            n4 |= 8;
        }
        if ((string = (String)properties.remove("top")) != null && new Boolean(string).booleanValue()) {
            n4 |= 1;
        }
        if ((string = (String)properties.remove("bottom")) != null && new Boolean(string).booleanValue()) {
            n4 |= 2;
        }
        this.setBorder(n4);
        String string2 = (String)properties.remove("red");
        String string3 = (String)properties.remove("green");
        String string4 = (String)properties.remove("blue");
        if (string2 != null || string3 != null || string4 != null) {
            n3 = 0;
            n2 = 0;
            n = 0;
            if (string2 != null) {
                n3 = Integer.parseInt(string2);
            }
            if (string3 != null) {
                n2 = Integer.parseInt(string3);
            }
            if (string4 != null) {
                n = Integer.parseInt(string4);
            }
            this.setBorderColor(new Color(n3, n2, n));
        } else {
            string = (String)properties.remove("bordercolor");
            if (string != null) {
                this.setBorderColor(MarkupParser.decodeColor(string));
            }
        }
        string2 = (String)properties.remove("bgred");
        string3 = (String)properties.remove("bggreen");
        string4 = (String)properties.remove("bgblue");
        if (string2 != null || string3 != null || string4 != null) {
            n3 = 0;
            n2 = 0;
            n = 0;
            if (string2 != null) {
                n3 = Integer.parseInt(string2);
            }
            if (string3 != null) {
                n2 = Integer.parseInt(string3);
            }
            if (string4 != null) {
                n = Integer.parseInt(string4);
            }
            this.setBackgroundColor(new Color(n3, n2, n));
        } else {
            string = (String)properties.remove("backgroundcolor");
            if (string != null) {
                this.setBackgroundColor(MarkupParser.decodeColor(string));
            }
        }
        string = (String)properties.remove("grayfill");
        if (string != null) {
            this.setGrayFill(Float.valueOf(string + "f").floatValue());
        }
        if (properties.size() > 0) {
            this.setMarkupAttributes(properties);
        }
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 20;
    }

    public ArrayList getChunks() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.arrayList.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((Element)iterator.next()).getChunks());
        }
        return arrayList;
    }

    public void addElement(Element element) throws BadElementException {
        if (this.isTable()) {
            Table table = (Table)this.arrayList.get(0);
            Cell cell = new Cell(element);
            cell.setBorder(0);
            cell.setColspan(table.columns());
            table.addCell(cell);
            return;
        }
        switch (element.type()) {
            case 15: 
            case 20: 
            case 21: {
                throw new BadElementException("You can't add listitems, rows or cells to a cell.");
            }
            case 14: {
                if (Float.isNaN(this.leading)) {
                    this.leading = ((List)element).leading();
                }
                if (((List)element).size() == 0) {
                    return;
                }
                this.arrayList.add(element);
                return;
            }
            case 11: 
            case 12: 
            case 17: {
                if (Float.isNaN(this.leading)) {
                    this.leading = ((Phrase)element).leading();
                }
                if (((Phrase)element).isEmpty()) {
                    return;
                }
                this.arrayList.add(element);
                return;
            }
            case 10: {
                if (((Chunk)element).isEmpty()) {
                    return;
                }
                this.arrayList.add(element);
                return;
            }
            case 22: {
                Cell cell;
                Table table = new Table(3);
                float[] fArray = new float[3];
                fArray[1] = ((Table)element).widthPercentage();
                switch (((Table)element).alignment()) {
                    case 0: {
                        fArray[0] = 0.0f;
                        fArray[2] = 100.0f - fArray[1];
                        break;
                    }
                    case 1: {
                        fArray[0] = (100.0f - fArray[1]) / 2.0f;
                        fArray[2] = fArray[0];
                        break;
                    }
                    case 2: {
                        fArray[0] = 100.0f - fArray[1];
                        fArray[2] = 0.0f;
                    }
                }
                table.setWidths(fArray);
                if (this.arrayList.size() == 0) {
                    table.addCell(Cell.getDummyCell());
                } else {
                    cell = new Cell();
                    cell.setBorder(0);
                    cell.setColspan(3);
                    Iterator iterator = this.arrayList.iterator();
                    while (iterator.hasNext()) {
                        cell.add((Element)iterator.next());
                    }
                    table.addCell(cell);
                }
                cell = new Cell();
                cell.setBorder(0);
                table.addCell(cell);
                table.insertTable((Table)element);
                table.addCell(cell);
                table.addCell(Cell.getDummyCell());
                this.clear();
                this.arrayList.add(table);
                return;
            }
        }
        this.arrayList.add(element);
    }

    public boolean add(Object object) {
        try {
            this.addElement((Element)object);
            return true;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("You can only add objects that implement the Element interface.");
        }
        catch (BadElementException badElementException) {
            throw new ClassCastException(badElementException.getMessage());
        }
    }

    public void setLeading(float f) {
        this.leading = f;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public void setHorizontalAlignment(String string) {
        if ("Center".equalsIgnoreCase(string)) {
            this.horizontalAlignment = 1;
            return;
        }
        if ("Right".equalsIgnoreCase(string)) {
            this.horizontalAlignment = 2;
            return;
        }
        if ("Justify".equalsIgnoreCase(string)) {
            this.horizontalAlignment = 3;
            return;
        }
        if ("JustifyAll".equalsIgnoreCase(string)) {
            this.horizontalAlignment = 8;
            return;
        }
        this.horizontalAlignment = 0;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    public void setVerticalAlignment(String string) {
        if ("Middle".equalsIgnoreCase(string)) {
            this.verticalAlignment = 5;
            return;
        }
        if ("Bottom".equalsIgnoreCase(string)) {
            this.verticalAlignment = 6;
            return;
        }
        if ("Baseline".equalsIgnoreCase(string)) {
            this.verticalAlignment = 7;
            return;
        }
        this.verticalAlignment = 4;
    }

    public void setWidth(String string) {
        this.width = string;
    }

    public void setColspan(int n) {
        this.colspan = n;
    }

    public void setRowspan(int n) {
        this.rowspan = n;
    }

    public void setHeader(boolean bl) {
        this.header = bl;
    }

    public void setNoWrap(boolean bl) {
        this.maxLines = 1;
    }

    public int size() {
        return this.arrayList.size();
    }

    public boolean isEmpty() {
        switch (this.size()) {
            case 0: {
                return true;
            }
            case 1: {
                Element element = (Element)this.arrayList.get(0);
                switch (element.type()) {
                    case 10: {
                        return ((Chunk)element).isEmpty();
                    }
                    case 11: 
                    case 12: 
                    case 17: {
                        return ((Phrase)element).isEmpty();
                    }
                    case 14: {
                        return ((List)element).size() == 0;
                    }
                }
                return false;
            }
        }
        return false;
    }

    void fill() {
        if (this.size() == 0) {
            this.arrayList.add(new Paragraph(0.0f));
        }
    }

    public boolean isTable() {
        return this.size() == 1 && ((Element)this.arrayList.get(0)).type() == 22;
    }

    public Iterator getElements() {
        return this.arrayList.iterator();
    }

    public int horizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int verticalAlignment() {
        return this.verticalAlignment;
    }

    public String cellWidth() {
        return this.width;
    }

    public int colspan() {
        return this.colspan;
    }

    public int rowspan() {
        return this.rowspan;
    }

    public float leading() {
        if (Float.isNaN(this.leading)) {
            return 16.0f;
        }
        return this.leading;
    }

    public boolean header() {
        return this.header;
    }

    public boolean noWrap() {
        return this.maxLines == 1;
    }

    public void clear() {
        this.arrayList.clear();
    }

    public float top() {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public float bottom() {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public float left() {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public float right() {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public float top(int n) {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public float bottom(int n) {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public float left(int n) {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public float right(int n) {
        throw new UnsupportedOperationException("Dimensions of a Cell can't be calculated. See the FAQ.");
    }

    public void setTop(int n) {
        throw new UnsupportedOperationException("Dimensions of a Cell are attributed automagically. See the FAQ.");
    }

    public void setBottom(int n) {
        throw new UnsupportedOperationException("Dimensions of a Cell are attributed automagically. See the FAQ.");
    }

    public void setLeft(int n) {
        throw new UnsupportedOperationException("Dimensions of a Cell are attributed automagically. See the FAQ.");
    }

    public void setRight(int n) {
        throw new UnsupportedOperationException("Dimensions of a Cell are attributed automagically. See the FAQ.");
    }

    public static boolean isTag(String string) {
        return "cell".equals(string);
    }

    public boolean getGroupChange() {
        return this.groupChange;
    }

    public void setGroupChange(boolean bl) {
        this.groupChange = bl;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int n) {
        this.maxLines = n;
    }

    public void setShowTruncation(String string) {
        this.showTruncation = string;
    }

    public String getShowTruncation() {
        return this.showTruncation;
    }

    public void setUseAscender(boolean bl) {
        this.useAscender = bl;
    }

    public boolean isUseAscender() {
        return this.useAscender;
    }

    public void setUseDescender(boolean bl) {
        this.useDescender = bl;
    }

    public boolean isUseDescender() {
        return this.useDescender;
    }

    public void setUseBorderPadding(boolean bl) {
        this.useBorderPadding = bl;
    }

    public boolean isUseBorderPadding() {
        return this.useBorderPadding;
    }
}

