/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.OptionArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Txt2Pdf
extends AbstractTool {
    public Txt2Pdf() {
        this.menuoptions = 11;
        this.arguments.add(new FileArgument((AbstractTool)this, "srcfile", "The file you want to convert", false));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted text has to be written", true, new PdfFilter()));
        OptionArgument optionArgument = new OptionArgument(this, "pagesize", "Pagesize");
        optionArgument.addOption("A4", "A4");
        optionArgument.addOption("Letter", "LETTER");
        this.arguments.add(optionArgument);
        OptionArgument optionArgument2 = new OptionArgument(this, "orientation", "Orientation of the page");
        optionArgument2.addOption("Portrait", "PORTRAIT");
        optionArgument2.addOption("Landscape", "LANDSCAPE");
        this.arguments.add(optionArgument2);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Txt2Pdf", true, true, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
    }

    public void execute() {
        try {
            Document document;
            Font font;
            String string = null;
            Rectangle rectangle = "LETTER".equals(this.getValue("pagesize")) ? PageSize.LETTER : PageSize.A4;
            if ("LANDSCAPE".equals(this.getValue("orientation"))) {
                font = FontFactory.getFont("Courier", 10.0f);
                document = new Document(rectangle.rotate(), 36.0f, 9.0f, 36.0f, 36.0f);
            } else {
                font = FontFactory.getFont("Courier", 11.0f);
                document = new Document(rectangle, 72.0f, 36.0f, 36.0f, 36.0f);
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader((File)this.getValue("srcfile")));
            PdfWriter.getInstance(document, new FileOutputStream((File)this.getValue("destfile")));
            document.open();
            while ((string = bufferedReader.readLine()) != null) {
                document.add(new Paragraph(12.0f, string, font));
            }
            document.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Txt2Pdf txt2Pdf = new Txt2Pdf();
        if (stringArray.length < 2) {
            System.err.println(txt2Pdf.getUsage());
        }
        txt2Pdf.setArguments(stringArray);
        txt2Pdf.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

