package tudu.web;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.springframework.webflow.Event;
import org.springframework.webflow.ParameterMap;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.action.MultiAction;

import tudu.domain.model.TodoList;
import tudu.domain.model.User;
import tudu.service.TodoListsManager;
import tudu.service.UserManager;

public class TodoListsAction extends MultiAction {

	private UserManager userManager;
	private TodoListsManager todoListsManager;
	
	public Event list(RequestContext context) throws Exception {
        System.out.println("Passage dans TodoListsAction.list");
		User user = userManager.getCurrentUser();
        Collection<TodoList> todoLists = user.getTodoLists();
		context.getRequestScope().put("todoLists", todoLists);
		return success();
	}

	public Event detail(RequestContext context) throws Exception {
		System.out.println("Passage dans TodoListsAction.detail");
		//String data = (String)context.getSourceEvent().getParameter("data");
		//Map attributes=context.getSourceEvent().getParameters();
		ParameterMap parameters = context.getRequestParameters();
		Map attributes = parameters.getMap();
		String listId = (String)attributes.get("id");
		Set attributeKeys=attributes.keySet();
		for(Iterator i=attributeKeys.iterator();i.hasNext();) {
			String key=(String)i.next();
			Object value=attributes.get(key);
			System.out.println(" - "+key+"="+value);
		}
		//String listId = (String)context.getSourceEvent().getParameter("id");
		/*ParameterMap parameters = context.getRequestParameters();
		String listId = parameters.get("id");*/
		TodoList todoList = todoListsManager.findTodoList(listId);
		context.getRequestScope().put("todoList", todoList);
		return success();
	}

	public Event end(RequestContext context) throws Exception {
		System.out.println("Passage dans TodoListsAction.end");
		return success();
	}

	public UserManager getUserManager() {
		return userManager;
	}

	public void setUserManager(UserManager userManager) {
		this.userManager = userManager;
	}

	public TodoListsManager getTodoListsManager() {
		return todoListsManager;
	}

	public void setTodoListsManager(TodoListsManager todoListsManager) {
		this.todoListsManager = todoListsManager;
	}

}
