package tudu.web;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.springframework.webflow.Event;
import org.springframework.webflow.ParameterMap;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.action.MultiAction;

import tudu.domain.model.TodoList;
import tudu.service.TodoListsManager;

public class TodosAction extends MultiAction {

	private TodoListsManager todoListsManager;
	
	private void showFlowParameters(RequestContext context) {
		ParameterMap parameters = context.getRequestParameters();
		Map attributes=parameters.getMap();
		Set attributeKeys=attributes.keySet();
		for(Iterator i=attributeKeys.iterator();i.hasNext();) {
			String key=(String)i.next();
			Object value=attributes.get(key);
			System.out.println(" - "+key+"="+value);
		}
	}
	
	public Event list(RequestContext context) throws Exception {
        System.out.println("Passage dans TodosAction.list");
		//String listId = (String)context.getSourceEvent().getParameter("id");
		ParameterMap parameters = context.getRequestParameters();
		String listId = parameters.get("id");
		System.out.println("listId = "+listId);
		showFlowParameters(context);
		TodoList todoList = todoListsManager.findTodoList(listId);
		context.getRequestScope().put("todoList", todoList);
		context.getRequestScope().put("todos", todoList.getTodos());
		return success();
	}

	public Event detail(RequestContext context) throws Exception {
		System.out.println("Passage dans TodosAction.detail");
		//String data = (String)context.getSourceEvent().getParameter("todoListId");
		ParameterMap parameters = context.getRequestParameters();
		String listId = parameters.get("id");
		TodoList todoList = todoListsManager.findTodoList(listId);
		context.getRequestScope().put("todoList", todoList);
		context.getRequestScope().put("todos", todoList.getTodos());
		return success();
	}

	public Event end(RequestContext context) throws Exception {
		System.out.println("Passage dans TodosAction.end");
		return success();
	}

	public TodoListsManager getTodoListsManager() {
		return todoListsManager;
	}

	public void setTodoListsManager(TodoListsManager todoListsManager) {
		this.todoListsManager = todoListsManager;
	}

}
