package tudu.web;

import org.springframework.webflow.Event;
import org.springframework.webflow.ParameterMap;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.ScopeType;
import org.springframework.webflow.action.FormAction;

import tudu.domain.model.Todo;
import tudu.service.TodosManager;

public class TodoAction extends FormAction {

	private TodosManager todosManager;

	public TodoAction() {
		System.out.println("Passage dans TodoAction.cstr");
		setFormObjectName("todo");
		setFormObjectClass(Todo.class);
		setFormObjectScope(ScopeType.FLOW);
	}

	public Object createFormObject(RequestContext context)
			throws Exception {
		System.out.println("Passage dans TodoAction.createFormObject");
		//String todoId = (String)context.getSourceEvent().getParameter("id");
		ParameterMap parameters = context.getRequestParameters();
		String todoId = parameters.get("id");
		return todosManager.findTodo(todoId);
	}

	public Event save(RequestContext context) throws Exception {
		System.out.println("Passage dans TodoAction.save");
		//Todo todo = (Todo)context.getFlowScope().getAttribute("todo");
		Todo todo = (Todo)context.getFlowScope().get("todo");
		todosManager.updateTodo(todo);
		return success();
	}

	public TodosManager getTodosManager() {
		return todosManager;
	}

	public void setTodosManager(TodosManager todosManager) {
		this.todosManager = todosManager;
	}
}
