package tudu.web;

import org.springframework.webflow.Event;
import org.springframework.webflow.ParameterMap;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.ScopeType;
import org.springframework.webflow.action.FormAction;

import tudu.domain.model.TodoList;
import tudu.service.TodoListsManager;

public class TodoListAction extends FormAction {

	private TodoListsManager todoListsManager;

	public TodoListAction() {
		System.out.println("Passage dans TodoListAction.cstr");
		setFormObjectName("todoList");
		setFormObjectClass(TodoList.class);
		setFormObjectScope(ScopeType.FLOW);
	}

	public Object createFormObject(RequestContext context)
			throws Exception {
		System.out.println("Passage dans TodoListAction.createFormObject");
		//String listId = (String)context.getSourceEvent().getParameter("id");
		ParameterMap parameters = context.getRequestParameters();
		String listId = parameters.get("id");
		return todoListsManager.findTodoList(listId);
	}

	public Event save(RequestContext context) throws Exception {
		System.out.println("Passage dans TodoListAction.save");
		TodoList todoList = (TodoList)context.getFlowScope().get("todoList");
		todoListsManager.updateTodoList(todoList);
		return success();
	}

	public TodoListsManager getTodoListsManager() {
		return todoListsManager;
	}

	public void setTodoListsManager(TodoListsManager todoListsManager) {
		this.todoListsManager = todoListsManager;
	}
}
