/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.handler.AbstractHandlerSupport;
import org.codehaus.xfire.handler.DispatchServiceHandler;
import org.codehaus.xfire.handler.Phase;
import org.codehaus.xfire.service.DefaultServiceRegistry;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.transport.DefaultTransportManager;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.wsdl.WSDLWriter;

public class DefaultXFire
extends AbstractHandlerSupport
implements XFire {
    private ServiceRegistry registry;
    private TransportManager transportManager;
    private List inPhases;
    private List outPhases;
    private List faultPhases;

    public DefaultXFire() {
        this.registry = new DefaultServiceRegistry();
        this.transportManager = new DefaultTransportManager(this.registry);
        this.createPhases();
        this.createHandlers();
    }

    public DefaultXFire(ServiceRegistry registry, TransportManager transportManager) {
        this.registry = registry;
        this.transportManager = transportManager;
        this.createPhases();
        this.createHandlers();
    }

    protected void createHandlers() {
        this.addInHandler(new DispatchServiceHandler());
    }

    protected void createPhases() {
        this.inPhases = new ArrayList();
        this.inPhases.add(new Phase("transport", 1000));
        this.inPhases.add(new Phase("parse", 2000));
        this.inPhases.add(new Phase("pre-dispatch", 3000));
        this.inPhases.add(new Phase("dispatch", 4000));
        this.inPhases.add(new Phase("policy", 5000));
        this.inPhases.add(new Phase("user", 6000));
        this.inPhases.add(new Phase("pre-invoke", 7000));
        this.inPhases.add(new Phase("service", 8000));
        this.outPhases = new ArrayList();
        this.outPhases.add(new Phase("post-invoke", 1000));
        this.outPhases.add(new Phase("policy", 2000));
        this.outPhases.add(new Phase("user", 3000));
        this.outPhases.add(new Phase("transport", 4000));
        this.outPhases.add(new Phase("send", 5000));
        this.faultPhases = new ArrayList();
        this.faultPhases.add(new Phase("policy", 1000));
        this.faultPhases.add(new Phase("user", 2000));
        this.faultPhases.add(new Phase("transport", 3000));
        this.faultPhases.add(new Phase("send", 4000));
    }

    protected Service findService(String serviceName) {
        Service service = this.getServiceRegistry().getService(serviceName);
        if (service == null) {
            throw new XFireRuntimeException("Couldn't find service " + serviceName);
        }
        return service;
    }

    public void generateWSDL(String serviceName, OutputStream out) {
        try {
            WSDLWriter wsdl = this.getWSDL(serviceName);
            wsdl.write(out);
        }
        catch (IOException e) {
            throw new XFireRuntimeException("Couldn't generate WSDL.", e);
        }
    }

    private WSDLWriter getWSDL(String serviceName) {
        Service service = this.findService(serviceName);
        return service.getWSDLWriter();
    }

    public ServiceRegistry getServiceRegistry() {
        return this.registry;
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    public List getInPhases() {
        return this.inPhases;
    }

    public void setInPhases(List inPhases) {
        this.inPhases = inPhases;
    }

    public List getOutPhases() {
        return this.outPhases;
    }

    public void setOutPhases(List outPhases) {
        this.outPhases = outPhases;
    }

    public List getFaultPhases() {
        return this.faultPhases;
    }

    public void setFaultPhases(List faultPhases) {
        this.faultPhases = faultPhases;
    }
}

