/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.addressing;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.xfire.addressing.AbstactAddressingHeadersFactory;
import org.codehaus.xfire.addressing.AddressingHeaders;
import org.codehaus.xfire.addressing.EndpointReference;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class AbstactAddressingHeadersFactory2005
extends AbstactAddressingHeadersFactory {
    protected abstract Namespace getNamespace();

    public AddressingHeaders createHeaders(Element root) {
        Element action;
        Element to;
        Element messageId;
        Element faultTo;
        Element replyTo;
        AddressingHeaders headers = new AddressingHeaders();
        Namespace wsa = this.getNamespace();
        Element from = root.getChild("From", wsa);
        if (from != null) {
            headers.setFrom(this.createEPR(from));
        }
        if ((replyTo = root.getChild("ReplyTo", wsa)) != null) {
            headers.setReplyTo(this.createEPR(replyTo));
        }
        if ((faultTo = root.getChild("FaultTo", wsa)) != null) {
            headers.setFaultTo(this.createEPR(faultTo));
        }
        if ((messageId = root.getChild("MessageID", wsa)) != null) {
            headers.setMessageID(messageId.getValue());
        }
        if ((to = root.getChild("To", wsa)) != null) {
            headers.setTo(to.getValue());
        }
        if ((action = root.getChild("Action", wsa)) != null) {
            headers.setAction(action.getValue());
        }
        return headers;
    }

    public EndpointReference createEPR(Element eprElement) {
        EndpointReference epr = new EndpointReference();
        Object anyContent = null;
        List elements = eprElement.getChildren();
        String version = eprElement.getNamespaceURI();
        Namespace wsa = this.getNamespace();
        epr.setElement(eprElement);
        for (int i = 0; i < elements.size(); ++i) {
            Element e = (Element)elements.get(i);
            if (!e.getNamespaceURI().equals(version)) continue;
            if (e.getName().equals("ServiceName")) {
                epr.setServiceName(AbstactAddressingHeadersFactory2005.elementToQName(e));
                epr.setEndpointName(e.getAttributeValue("EndpointName", version));
                continue;
            }
            if (e.getName().equals("InterfaceName")) {
                epr.setInterfaceName(AbstactAddressingHeadersFactory2005.elementToQName(e));
                continue;
            }
            if (!e.getName().equals("Policies")) continue;
            ArrayList policies = new ArrayList();
            List polEls = e.getChildren();
            for (int j = 0; j < polEls.size(); ++j) {
                policies.add(polEls.get(j));
            }
            epr.setPolicies(policies);
        }
        return epr;
    }

    public boolean hasHeaders(Element root) {
        return root.getChild("Action", this.getNamespace()) != null;
    }

    public void writeHeaders(Element root, AddressingHeaders headers) {
        Namespace ns = this.getNamespace();
        root.addNamespaceDeclaration(ns);
        if (headers.getTo() != null) {
            Element to = new Element("To", ns);
            to.addContent(headers.getTo());
            root.addContent((Content)to);
        }
        if (headers.getAction() != null) {
            Element action = new Element("Action", ns);
            action.addContent(headers.getAction());
            root.addContent((Content)action);
        }
        if (headers.getFaultTo() != null) {
            Element faultTo = new Element("FaultTo", ns);
            root.addContent((Content)faultTo);
            this.writeEPR(faultTo, headers.getFaultTo());
        }
        if (headers.getFrom() != null) {
            Element from = new Element("From", ns);
            root.addContent((Content)from);
            this.writeEPR(from, headers.getFrom());
        }
        if (headers.getMessageID() != null) {
            Element messageId = new Element("MessageID", ns);
            messageId.addContent(headers.getMessageID());
            root.addContent((Content)messageId);
        }
        if (headers.getRelatesTo() != null) {
            Element relatesTo = new Element("RelatesTo", ns);
            relatesTo.addContent(headers.getRelatesTo());
            root.addContent((Content)relatesTo);
            if (headers.getRelationshipType() != null) {
                String value = AbstactAddressingHeadersFactory2005.qnameToString(root, headers.getRelationshipType());
                relatesTo.setAttribute(new Attribute("RelationshipType", value));
            }
        }
        if (headers.getReplyTo() != null) {
            Element replyTo = new Element("ReplyTo", ns);
            root.addContent((Content)replyTo);
            this.writeEPR(replyTo, headers.getReplyTo());
        }
    }

    public void writeEPR(Element root, EndpointReference epr) {
        Namespace ns = this.getNamespace();
        Element address = new Element("Address", ns);
        address.addContent(epr.getAddress());
        root.addContent((Content)address);
        if (epr.getServiceName() != null) {
            Element serviceName = new Element("ServiceName", ns);
            serviceName.addContent(AbstactAddressingHeadersFactory2005.qnameToString((Element)root.getParent(), epr.getServiceName()));
            root.addContent((Content)serviceName);
            if (epr.getInterfaceName() != null) {
                String value = AbstactAddressingHeadersFactory2005.qnameToString((Element)root.getParent(), epr.getInterfaceName());
                serviceName.setAttribute(new Attribute("InterfaceName", value));
            }
        }
    }
}

