/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.addressing;

import java.util.Iterator;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.ServiceInfo;

public class AddressingOperationInfo {
    private String inAction;
    private String outAction;
    private OperationInfo operationInfo;
    public static final String ADDRESSING_OPERATION_KEY = "addressingOperationInfo";

    public AddressingOperationInfo(String inAction, OperationInfo op) {
        this(inAction, inAction + "Ack", op);
    }

    public AddressingOperationInfo(String inAction, String outAction, OperationInfo op) {
        this.inAction = inAction;
        this.outAction = outAction;
        op.setProperty(ADDRESSING_OPERATION_KEY, this);
        this.operationInfo = op;
    }

    public static AddressingOperationInfo getAddressingOperationInfo(OperationInfo op) {
        return (AddressingOperationInfo)op.getProperty(ADDRESSING_OPERATION_KEY);
    }

    public static String getInAction(OperationInfo op) {
        AddressingOperationInfo aoi = AddressingOperationInfo.getAddressingOperationInfo(op);
        if (aoi == null) {
            return null;
        }
        return aoi.getInAction();
    }

    public static String getOutAction(OperationInfo op) {
        AddressingOperationInfo aoi = AddressingOperationInfo.getAddressingOperationInfo(op);
        if (aoi == null) {
            return null;
        }
        return aoi.getOutAction();
    }

    public static AddressingOperationInfo getOperationByInAction(ServiceInfo service, String name) {
        Iterator itr = service.getOperations().iterator();
        while (itr.hasNext()) {
            OperationInfo op = (OperationInfo)itr.next();
            AddressingOperationInfo aoi = AddressingOperationInfo.getAddressingOperationInfo(op);
            if (aoi == null || aoi.getInAction() == null || !aoi.getInAction().equals(name)) continue;
            return aoi;
        }
        if (!name.equals("*")) {
            return AddressingOperationInfo.getOperationByInAction(service, "*");
        }
        return null;
    }

    public String getInAction() {
        return this.inAction;
    }

    public void setInAction(String inAction) {
        this.inAction = inAction;
    }

    public String getOutAction() {
        return this.outAction;
    }

    public void setOutAction(String outAction) {
        this.outAction = outAction;
    }

    public OperationInfo getOperationInfo() {
        return this.operationInfo;
    }

    public void setOperationInfo(OperationInfo operationInfo) {
        this.operationInfo = operationInfo;
    }
}

