/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.basic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.Base64;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class ObjectType
extends Type {
    private static final QName XSI_TYPE = new QName("http://www.w3.org/2001/XMLSchema-instance", "type");
    private static final QName XSI_NIL = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil");
    private final Set dependencies;
    private final boolean serializeWhenUnknown;
    static /* synthetic */ Class class$java$lang$Object;

    public ObjectType() {
        this(Collections.EMPTY_SET);
    }

    public ObjectType(Set dependencies) {
        this(dependencies, false);
    }

    public ObjectType(boolean serializeWhenUnknown) {
        this(Collections.EMPTY_SET, serializeWhenUnknown);
    }

    public ObjectType(Set dependencies, boolean serializeWhenUnknown) {
        this.dependencies = dependencies;
        this.serializeWhenUnknown = serializeWhenUnknown;
    }

    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        if (this.isNil(reader.getAttributeReader(XSI_NIL))) {
            while (reader.hasMoreElementReaders()) {
                reader.getNextElementReader();
            }
            return null;
        }
        MessageReader typeReader = reader.getAttributeReader(XSI_TYPE);
        if (null == typeReader) {
            throw new XFireFault("Missing 'xsi:type' attribute", "Sender");
        }
        String typeName = typeReader.getValue();
        if (null == typeName) {
            throw new XFireFault("Missing 'xsi:type' attribute value", "Sender");
        }
        QName typeQName = this.extractQName(reader, typeName);
        Type type = this.getTypeMapping().getType(typeQName);
        if (null == type) {
            if (this.serializeWhenUnknown && "serializedJavaObject".equals(typeQName.getLocalPart())) {
                return this.reconstituteJavaObject(reader);
            }
            throw new XFireFault("No mapped type for '" + typeQName + "'", "Sender");
        }
        return type.readObject(reader, context);
    }

    private QName extractQName(MessageReader reader, String typeName) {
        int colon = typeName.indexOf(58);
        if (-1 == colon) {
            return new QName(reader.getNamespace(), typeName);
        }
        return new QName(reader.getNamespaceForPrefix(typeName.substring(0, colon)), typeName.substring(colon + 1));
    }

    private Object reconstituteJavaObject(MessageReader reader) throws XFireFault {
        ByteArrayInputStream in = new ByteArrayInputStream(Base64.decode(reader.getValue()));
        try {
            return new ObjectInputStream(in).readObject();
        }
        catch (Exception e) {
            throw new XFireFault("Unable to reconstitute serialized object", e, "Receiver");
        }
    }

    private boolean isNil(MessageReader reader) {
        return null != reader && "true".equals(reader.getValue());
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        if (null == object) {
            MessageWriter nilWriter = writer.getAttributeWriter(XSI_NIL);
            nilWriter.writeValue("true");
            nilWriter.close();
        } else {
            Type type = this.determineType(object.getClass());
            if (null == type) {
                this.handleNullType(object, writer);
            } else {
                String prefix = writer.getPrefixForNamespace(type.getSchemaType().getNamespaceURI());
                if (null == prefix || prefix.length() == 0) {
                    this.addXsiType(writer, type.getSchemaType().getLocalPart());
                } else {
                    this.addXsiType(writer, prefix + ":" + type.getSchemaType().getLocalPart());
                }
                type.writeObject(object, writer, context);
            }
        }
    }

    private Type determineType(Class clazz) {
        TypeMapping mapping = this.getTypeMapping();
        Type type = mapping.getType(clazz);
        if (null != type) {
            return type;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            type = mapping.getType(anInterface);
            if (null == type) continue;
            return type;
        }
        Class superclass = clazz.getSuperclass();
        if (null == superclass || (class$java$lang$Object == null ? (class$java$lang$Object = ObjectType.class$("java.lang.Object")) : class$java$lang$Object).equals(superclass)) {
            return null;
        }
        return this.determineType(superclass);
    }

    private void addXsiType(MessageWriter writer, String prefixedType) {
        MessageWriter typeWriter = writer.getAttributeWriter(XSI_TYPE);
        typeWriter.writeValue(prefixedType);
        typeWriter.close();
    }

    private void handleNullType(Object object, MessageWriter writer) throws XFireFault {
        if (!this.serializeWhenUnknown) {
            throw new XFireFault("Unable to write '" + object + "' [" + object.getClass().getName() + "]", "Receiver");
        }
        this.addXsiType(writer, "serializedJavaObject");
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(out);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        catch (IOException e) {
            throw new XFireFault("Unable to serialize '" + object + "' [" + object.getClass().getName() + "]", e, "Receiver");
        }
        writer.writeValue(Base64.encode(out.toByteArray()));
    }

    public Set getDependencies() {
        return this.dependencies;
    }

    public boolean isComplex() {
        return true;
    }

    public void writeSchema(Element root) {
        if (this.serializeWhenUnknown) {
            Element simple = new Element("simpleType", "xsd", "http://www.w3.org/2001/XMLSchema");
            simple.setAttribute(new Attribute("name", "serializedJavaObject"));
            root.addContent((Content)simple);
            Element restriction = new Element("restriction", "xsd", "http://www.w3.org/2001/XMLSchema");
            restriction.setAttribute(new Attribute("base", "xsd:base64Binary"));
            simple.addContent((Content)restriction);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

