/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.annotations;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.annotations.AnnotationException;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.annotations.WebMethodAnnotation;
import org.codehaus.xfire.annotations.WebParamAnnotation;
import org.codehaus.xfire.annotations.WebResultAnnotation;
import org.codehaus.xfire.annotations.WebServiceAnnotation;
import org.codehaus.xfire.annotations.soap.SOAPBindingAnnotation;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.ServiceInfo;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.xfire.util.NamespaceHelper;

public class AnnotationServiceFactory
extends ObjectServiceFactory
implements ServiceFactory {
    private WebAnnotations webAnnotations;

    public AnnotationServiceFactory(WebAnnotations webAnnotations, TransportManager transportManager) {
        super(transportManager, new AegisBindingProvider());
        this.webAnnotations = webAnnotations;
    }

    public AnnotationServiceFactory(WebAnnotations webAnnotations, TransportManager transportManager, BindingProvider provider) {
        super(transportManager, provider);
        this.webAnnotations = webAnnotations;
    }

    public Service create(Class clazz, String name, String namespace, Map properties) {
        String style = null;
        String use = null;
        if (properties == null) {
            properties = new HashMap<String, Object>();
        }
        if (this.webAnnotations.hasSOAPBindingAnnotation(clazz)) {
            SOAPBindingAnnotation soapBindingAnnotation = this.webAnnotations.getSOAPBindingAnnotation(clazz);
            style = soapBindingAnnotation.getStyleString();
            use = soapBindingAnnotation.getUseString();
        }
        if (this.webAnnotations.hasWebServiceAnnotation(clazz)) {
            WebServiceAnnotation webServiceAnnotation = this.webAnnotations.getWebServiceAnnotation(clazz);
            name = this.createServiceName(clazz, webServiceAnnotation, name);
            String portType = null;
            Class endpointInterface = clazz;
            if (webServiceAnnotation.getEndpointInterface() != null && webServiceAnnotation.getEndpointInterface().length() != 0) {
                try {
                    endpointInterface = this.loadClass(webServiceAnnotation.getEndpointInterface());
                    if (!this.webAnnotations.hasWebServiceAnnotation(endpointInterface)) {
                        throw new AnnotationException("Endpoint interface " + endpointInterface.getName() + " does not have a WebService annotation");
                    }
                    WebServiceAnnotation endpointWSAnnotation = this.webAnnotations.getWebServiceAnnotation(endpointInterface);
                    namespace = this.createServiceNamespace(endpointInterface, endpointWSAnnotation, namespace);
                    portType = this.createPortType(name, endpointWSAnnotation);
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Couldn't find endpoint interface " + webServiceAnnotation.getEndpointInterface(), e);
                }
            } else {
                namespace = this.createServiceNamespace(endpointInterface, webServiceAnnotation, namespace);
                portType = this.createPortType(name, webServiceAnnotation);
            }
            if (!properties.containsKey("objectServiceFactory.portType")) {
                properties.put("objectServiceFactory.portType", new QName(namespace, portType));
            }
            if (!properties.containsKey("sobjectServiceFactory.tyle")) {
                properties.put("sobjectServiceFactory.tyle", style);
            }
            if (!properties.containsKey("objectServiceFactory.use")) {
                properties.put("objectServiceFactory.use", use);
            }
            Service service = super.create(endpointInterface, name, namespace, properties);
            if (clazz != endpointInterface) {
                service.setProperty("xfire.serviceImplClass", clazz);
            }
            return service;
        }
        throw new AnnotationException("Class " + clazz.getName() + " does not have a WebService annotation");
    }

    protected Class loadClass(String endpointInterface) throws ClassNotFoundException {
        return ClassLoaderUtils.loadClass(endpointInterface, this.getClass());
    }

    protected String createServiceNamespace(Class clazz, WebServiceAnnotation webServiceAnnotation, String current) {
        String ns = current;
        if (ns == null && webServiceAnnotation.getTargetNamespace().length() > 0) {
            ns = webServiceAnnotation.getTargetNamespace();
        }
        if (ns == null) {
            ns = NamespaceHelper.makeNamespaceFromClassName(clazz.getName(), "http");
        }
        return ns;
    }

    protected String createServiceName(Class clazz, WebServiceAnnotation webServiceAnnotation, String current) {
        String name = current;
        if (name == null && webServiceAnnotation.getServiceName().length() > 0) {
            name = webServiceAnnotation.getServiceName();
        }
        if (name == null) {
            name = this.makeServiceNameFromClassName(clazz);
        }
        return name;
    }

    protected String createPortType(String serviceName, WebServiceAnnotation webServiceAnnotation) {
        String portType = null;
        portType = webServiceAnnotation.getName().length() > 0 ? webServiceAnnotation.getName() : serviceName + "PortType";
        return portType;
    }

    protected String getOperationName(ServiceInfo service, Method method) {
        WebMethodAnnotation wma;
        if (this.webAnnotations.hasWebMethodAnnotation(method) && (wma = this.webAnnotations.getWebMethodAnnotation(method)).getOperationName().length() > 0) {
            return wma.getOperationName();
        }
        return super.getOperationName(service, method);
    }

    protected String getAction(OperationInfo op) {
        WebMethodAnnotation wma;
        if (this.webAnnotations.hasWebMethodAnnotation(op.getMethod()) && (wma = this.webAnnotations.getWebMethodAnnotation(op.getMethod())).getAction().length() > 0) {
            return wma.getAction();
        }
        return super.getAction(op);
    }

    protected boolean isValidMethod(Method method) {
        if (!super.isValidMethod(method)) {
            return false;
        }
        if (method.getDeclaringClass().isInterface()) {
            return true;
        }
        return this.webAnnotations.hasWebMethodAnnotation(method);
    }

    protected boolean isHeader(Method method, int paramNumber) {
        if (paramNumber != -1 && this.webAnnotations.hasWebParamAnnotation(method, paramNumber)) {
            WebParamAnnotation webParamAnnotation = this.webAnnotations.getWebParamAnnotation(method, paramNumber);
            return webParamAnnotation.isHeader();
        }
        return super.isHeader(method, paramNumber);
    }

    protected QName getInParameterName(Service endpoint, OperationInfo op, Method method, int paramNumber, boolean doc) {
        if (this.webAnnotations.hasWebParamAnnotation(method, paramNumber)) {
            WebParamAnnotation webParamAnnotation = this.webAnnotations.getWebParamAnnotation(method, paramNumber);
            String name = webParamAnnotation.getName();
            String ns = webParamAnnotation.getTargetNamespace();
            if (ns == null || ns.length() == 0) {
                ns = endpoint.getTargetNamespace();
            }
            return new QName(ns, name);
        }
        return super.getInParameterName(endpoint, op, method, paramNumber, doc);
    }

    protected QName getOutParameterName(Service endpoint, OperationInfo op, Method method, boolean doc) {
        if (this.webAnnotations.hasWebResultAnnotation(method)) {
            WebResultAnnotation webResultAnnotation = this.webAnnotations.getWebResultAnnotation(method);
            String name = webResultAnnotation.getName();
            String ns = webResultAnnotation.getTargetNamespace();
            if (ns == null || ns.length() == 0) {
                ns = endpoint.getTargetNamespace();
            }
            return new QName(ns, name);
        }
        return super.getOutParameterName(endpoint, op, method, doc);
    }

    protected boolean isAsync(Method method) {
        return this.webAnnotations.hasOnewayAnnotation(method);
    }

    protected String getMEP(Method method) {
        if (this.webAnnotations.hasOnewayAnnotation(method)) {
            return "urn:xfire:mep:in";
        }
        return super.getMEP(method);
    }
}

