/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Iterator;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.client.XFireProxy;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.Endpoint;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.Transport;

public class XFireProxyFactory {
    private XFire xfire;

    public XFireProxyFactory() {
        this.xfire = XFireFactory.newInstance().getXFire();
    }

    public XFireProxyFactory(XFire xfire) {
        this.xfire = xfire;
    }

    public Object create(Service service, String url) throws MalformedURLException {
        Collection transports = this.xfire.getTransportManager().getTransportsForUri(url);
        if (transports.size() == 0) {
            throw new XFireRuntimeException("No Transport is available for url " + url);
        }
        Binding lastChoice = null;
        Binding firstChoice = null;
        Transport t = null;
        Iterator itr = service.getBindings().iterator();
        while (itr.hasNext()) {
            Binding binding = (Binding)itr.next();
            if (binding.getTransport() == null) {
                lastChoice = binding;
                continue;
            }
            if (!transports.contains(binding.getTransport())) continue;
            firstChoice = binding;
            t = binding.getTransport();
            break;
        }
        if (firstChoice == null && lastChoice == null) {
            throw new XFireRuntimeException("Could not find binding for url " + url);
        }
        if (firstChoice == null) {
            firstChoice = lastChoice;
            t = (Transport)transports.iterator().next();
        }
        Client client = new Client(firstChoice, url);
        client.setTransport(t);
        return this.create(client);
    }

    public Object create(Service service, Transport transport, String url) throws MalformedURLException {
        return this.create(new Client(transport, service, url));
    }

    public Object create(Client client) {
        client.setXFire(this.xfire);
        XFireProxy handler = new XFireProxy(client);
        Class serviceClass = client.getService().getServiceInfo().getServiceClass();
        return Proxy.newProxyInstance(serviceClass.getClassLoader(), new Class[]{serviceClass}, (InvocationHandler)handler);
    }

    public Object create(Endpoint endpoint) throws MalformedURLException {
        return this.create(new Client(endpoint));
    }

    public Object create(Binding binding, String address) throws MalformedURLException {
        Transport transport = binding.getTransport();
        if (transport == null) {
            throw new IllegalStateException("No such transport for binding.");
        }
        return this.create(binding.getService(), transport, address);
    }
}

