/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.handler;

import java.util.Iterator;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.service.FaultInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.util.stax.ElementStreamWriter;

public class CustomFaultHandler
extends AbstractHandler {
    public String getPhase() {
        return "user";
    }

    public void invoke(MessageContext context) throws Exception {
        XFireFault fault = (XFireFault)context.getExchange().getFaultMessage().getBody();
        Throwable cause = fault.getCause();
        MessagePartInfo faultPart = null;
        OperationInfo op = null;
        if (context.getExchange() != null) {
            op = context.getExchange().getOperation();
        }
        if (cause == null || op == null) {
            return;
        }
        faultPart = this.getFaultForClass(op, cause.getClass());
        if (faultPart != null) {
            ElementStreamWriter writer = new ElementStreamWriter(fault.getDetail());
            context.getService().getBindingProvider().writeParameter(faultPart, writer, context, cause);
        }
    }

    public MessagePartInfo getFaultForClass(OperationInfo op, Class class1) {
        Iterator itr = op.getFaults().iterator();
        while (itr.hasNext()) {
            FaultInfo faultInfo = (FaultInfo)itr.next();
            MessagePartInfo info = (MessagePartInfo)faultInfo.getMessageParts().get(0);
            if (!info.getTypeClass().equals(class1)) continue;
            return info;
        }
        return null;
    }
}

