/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.soap.handler;

import java.util.List;
import javax.xml.namespace.QName;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.soap.SoapVersion;
import org.jdom.Element;
import org.jdom.Namespace;

public class ValidateHeadersHandler
extends AbstractHandler {
    public String getPhase() {
        return "pre-invoke";
    }

    public void invoke(MessageContext context) throws Exception {
        if (context.getInMessage().getHeader() == null) {
            return;
        }
        SoapVersion version = context.getInMessage().getSoapVersion();
        List elements = context.getInMessage().getHeader().getChildren();
        for (int i = 0; i < elements.size(); ++i) {
            Element e = (Element)elements.get(i);
            String mustUnderstand = e.getAttributeValue("mustUnderstand", Namespace.getNamespace((String)version.getNamespace()));
            if (mustUnderstand == null || !mustUnderstand.equals("1") && (version != Soap12.getInstance() || !mustUnderstand.equals("true"))) continue;
            this.assertUnderstandsHeader(context, new QName(e.getNamespaceURI(), e.getName()));
        }
    }

    protected void assertUnderstandsHeader(MessageContext context, QName name) throws XFireFault {
        if (context.getInPipeline().understands(name)) {
            return;
        }
        if (context.getOutPipeline().understands(name)) {
            return;
        }
        throw new XFireFault("Header {" + name.getLocalPart() + "}" + name.getNamespaceURI() + " was not undertsood by the service.", "MustUnderstand");
    }
}

