/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.xfire.handler.AbstractHandlerSupport;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.util.UID;

public abstract class AbstractTransport
extends AbstractHandlerSupport
implements Transport {
    private Map channels = new HashMap();

    public void dispose() {
        Iterator itr = this.channels.values().iterator();
        while (itr.hasNext()) {
            Channel channel = (Channel)itr.next();
            channel.close();
        }
    }

    public Channel createChannel() throws Exception {
        return this.createChannel(this.getUriPrefix() + UID.generate());
    }

    public Channel createChannel(String uri) throws Exception {
        Channel c = (Channel)this.channels.get(uri);
        if (c == null) {
            c = this.createNewChannel(uri);
            this.channels.put(c.getUri(), c);
            c.open();
        }
        return c;
    }

    protected Map getChannelMap() {
        return this.channels;
    }

    public String[] getSupportedBindings() {
        return new String[0];
    }

    protected abstract Channel createNewChannel(String var1);

    protected abstract String getUriPrefix();

    protected abstract String[] getKnownUriSchemes();

    public boolean isUriSupported(String uri) {
        String[] schemes = this.getKnownUriSchemes();
        for (int i = 0; i < schemes.length; ++i) {
            if (!uri.startsWith(schemes[i])) continue;
            return true;
        }
        return false;
    }
}

