/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.local;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.AbstractChannel;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.Session;
import org.codehaus.xfire.transport.local.LocalTransport;
import org.codehaus.xfire.util.STAXUtils;

public class LocalChannel
extends AbstractChannel {
    private static final Log logger = LogFactory.getLog((Class)(class$org$codehaus$xfire$transport$local$LocalChannel == null ? (class$org$codehaus$xfire$transport$local$LocalChannel = LocalChannel.class$("org.codehaus.xfire.transport.local.LocalChannel")) : class$org$codehaus$xfire$transport$local$LocalChannel));
    protected static final String SENDER_URI = "senderUri";
    protected static final String OLD_CONTEXT = "urn:xfire:transport:local:oldContext";
    private final Session session;
    static /* synthetic */ Class class$org$codehaus$xfire$transport$local$LocalChannel;

    public LocalChannel(String uri, LocalTransport transport, Session session) {
        this.session = session;
        this.setUri(uri);
        this.setTransport(transport);
    }

    public void open() {
    }

    public void send(MessageContext context, OutMessage message) throws XFireException {
        if (message.getUri().equals("urn:xfire:channel:backchannel")) {
            OutputStream out = (OutputStream)context.getProperty("urn:xfire:channel:backchannel");
            if (out != null) {
                XMLStreamWriter writer = STAXUtils.createXMLStreamWriter(out, message.getEncoding());
                message.getSerializer().writeMessage(message, writer, context);
            } else {
                MessageContext oldContext = (MessageContext)context.getProperty(OLD_CONTEXT);
                this.sendViaNewChannel(context, oldContext, message, (String)context.getProperty(SENDER_URI));
            }
        } else {
            MessageContext receivingContext = new MessageContext();
            receivingContext.setXFire(context.getXFire());
            receivingContext.setService(this.getService(context.getXFire(), message.getUri()));
            receivingContext.setProperty(OLD_CONTEXT, context);
            receivingContext.setProperty(SENDER_URI, this.getUri());
            receivingContext.setSession(this.session);
            this.sendViaNewChannel(context, receivingContext, message, message.getUri());
        }
    }

    protected Service getService(XFire xfire, String uri) throws XFireException {
        if (null == xfire) {
            logger.warn((Object)"No XFire instance in context, unable to determine service");
            return null;
        }
        int i = uri.indexOf("//");
        if (i == -1) {
            throw new XFireException("Malformed service URI");
        }
        String name = uri.substring(i + 2);
        Service service = xfire.getServiceRegistry().getService(name);
        if (null == service) {
            logger.warn((Object)("Unable to locate '" + name + "' in ServiceRegistry"));
        }
        return service;
    }

    private void sendViaNewChannel(final MessageContext context, final MessageContext receivingContext, final OutMessage message, final String uri) throws XFireException {
        try {
            Channel channel;
            final PipedInputStream stream = new PipedInputStream();
            final PipedOutputStream outStream = new PipedOutputStream(stream);
            try {
                channel = this.getTransport().createChannel(uri);
            }
            catch (Exception e) {
                throw new XFireException("Couldn't create channel.", e);
            }
            Thread writeThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        XMLStreamWriter writer = STAXUtils.createXMLStreamWriter(outStream, message.getEncoding());
                        message.getSerializer().writeMessage(message, writer, context);
                        writer.close();
                        outStream.close();
                    }
                    catch (Exception e) {
                        throw new XFireRuntimeException("Couldn't write stream.", e);
                    }
                }
            });
            Thread readThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        XMLStreamReader reader = STAXUtils.createXMLStreamReader(stream, message.getEncoding());
                        InMessage inMessage = new InMessage(reader, uri);
                        inMessage.setEncoding(message.getEncoding());
                        channel.receive(receivingContext, inMessage);
                        reader.close();
                        stream.close();
                    }
                    catch (Exception e) {
                        throw new XFireRuntimeException("Couldn't read stream.", e);
                    }
                }
            });
            writeThread.start();
            readThread.start();
            try {
                writeThread.join();
            }
            catch (InterruptedException e) {}
        }
        catch (IOException e) {
            throw new XFireRuntimeException("Couldn't create stream.", e);
        }
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

