/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util.jdom;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMFactory;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.UncheckedJDOMFactory;

public class StaxBuilder {
    static final HashMap attrTypes = new HashMap(32);
    private JDOMFactory factory = null;
    private XMLInputFactory xifactory;
    protected boolean cfgIgnoreWS = false;
    private Map additionalNamespaces = null;

    public Map getAdditionalNamespaces() {
        return this.additionalNamespaces;
    }

    public void setAdditionalNamespaces(Map additionalNamespaces) {
        this.additionalNamespaces = additionalNamespaces;
    }

    public StaxBuilder() {
        this.xifactory = XMLInputFactory.newInstance();
    }

    public StaxBuilder(Map namespaces) {
        this.xifactory = XMLInputFactory.newInstance();
        this.additionalNamespaces = namespaces;
    }

    public StaxBuilder(XMLInputFactory xifactory) {
        this.xifactory = xifactory;
    }

    public void setFactory(JDOMFactory f) {
        this.factory = f;
    }

    public void setIgnoreWhitespace(boolean state) {
        this.cfgIgnoreWS = state;
    }

    public JDOMFactory getFactory() {
        return this.factory;
    }

    public Document build(XMLStreamReader r) throws XMLStreamException {
        JDOMFactory f = this.factory;
        if (f == null) {
            f = new UncheckedJDOMFactory();
        }
        Document doc = f.document(null);
        this.buildTree(f, r, doc);
        return doc;
    }

    public Document build(InputStream is) throws XMLStreamException {
        return this.build(this.xifactory.createXMLStreamReader(is));
    }

    public Document build(Reader reader) throws XMLStreamException {
        return this.build(this.xifactory.createXMLStreamReader(reader));
    }

    private void buildTree(JDOMFactory f, XMLStreamReader r, Document doc) throws XMLStreamException {
        Element current = null;
        int event = r.getEventType();
        if (event == -1) {
            event = r.next();
        }
        while (true) {
            boolean noadd = false;
            CDATA child = null;
            switch (event) {
                case 12: {
                    child = f.cdata(r.getText());
                    break;
                }
                case 6: {
                    if (this.cfgIgnoreWS) {
                        noadd = true;
                        break;
                    }
                }
                case 4: {
                    if (current == null) {
                        noadd = true;
                        break;
                    }
                    child = f.text(r.getText());
                    break;
                }
                case 5: {
                    child = f.comment(r.getText());
                    break;
                }
                case 8: {
                    return;
                }
                case 2: {
                    current = current.getParentElement();
                    noadd = true;
                    break;
                }
                case 14: 
                case 15: {
                    noadd = true;
                    break;
                }
                case 9: {
                    child = f.entityRef(r.getLocalName());
                    break;
                }
                case 3: {
                    child = f.processingInstruction(r.getPITarget(), r.getPIData());
                    break;
                }
                case 1: {
                    Namespace ns;
                    String prefix;
                    int i;
                    Element newElem = null;
                    String nsURI = r.getNamespaceURI();
                    String elemPrefix = r.getPrefix();
                    String ln = r.getLocalName();
                    newElem = nsURI == null || nsURI.length() == 0 ? (elemPrefix == null || elemPrefix.length() == 0 ? f.element(ln) : f.element(ln, elemPrefix, "")) : f.element(ln, elemPrefix, nsURI);
                    if (current == null) {
                        doc.setRootElement(newElem);
                        if (this.additionalNamespaces != null) {
                            Iterator iter = this.additionalNamespaces.keySet().iterator();
                            while (iter.hasNext()) {
                                String prefix2 = (String)iter.next();
                                String uri = (String)this.additionalNamespaces.get(prefix2);
                                newElem.addNamespaceDeclaration(Namespace.getNamespace((String)prefix2, (String)uri));
                            }
                        }
                    } else {
                        f.addContent((Parent)current, (Content)newElem);
                    }
                    int len = r.getNamespaceCount();
                    for (i = 0; i < len; ++i) {
                        prefix = r.getNamespacePrefix(i);
                        ns = Namespace.getNamespace((String)prefix, (String)r.getNamespaceURI(i));
                        if (prefix != null && prefix.equals(elemPrefix)) continue;
                        f.addNamespaceDeclaration(newElem, ns);
                    }
                    len = r.getAttributeCount();
                    for (i = 0; i < len; ++i) {
                        prefix = r.getAttributePrefix(i);
                        ns = prefix == null || prefix.length() == 0 ? Namespace.NO_NAMESPACE : newElem.getNamespace(prefix);
                        Attribute attr = f.attribute(r.getAttributeLocalName(i), r.getAttributeValue(i), StaxBuilder.resolveAttrType(r.getAttributeType(i)), ns);
                        f.setAttribute(newElem, attr);
                    }
                    current = newElem;
                    noadd = true;
                    break;
                }
            }
            if (!noadd && child != null) {
                if (current == null) {
                    f.addContent((Parent)doc, (Content)child);
                } else {
                    f.addContent((Parent)current, (Content)child);
                }
            }
            if (!r.hasNext()) break;
            event = r.next();
        }
    }

    private static int resolveAttrType(String typeStr) {
        Integer I;
        if (typeStr != null && typeStr.length() > 0 && (I = (Integer)attrTypes.get(typeStr)) != null) {
            return I;
        }
        return 0;
    }

    static {
        attrTypes.put("CDATA", new Integer(1));
        attrTypes.put("cdata", new Integer(1));
        attrTypes.put("ID", new Integer(2));
        attrTypes.put("id", new Integer(2));
        attrTypes.put("IDREF", new Integer(3));
        attrTypes.put("idref", new Integer(3));
        attrTypes.put("IDREFS", new Integer(4));
        attrTypes.put("idrefs", new Integer(4));
        attrTypes.put("ENTITY", new Integer(5));
        attrTypes.put("entity", new Integer(5));
        attrTypes.put("ENTITIES", new Integer(6));
        attrTypes.put("entities", new Integer(6));
        attrTypes.put("NMTOKEN", new Integer(7));
        attrTypes.put("nmtoken", new Integer(7));
        attrTypes.put("NMTOKENS", new Integer(8));
        attrTypes.put("nmtokens", new Integer(8));
        attrTypes.put("NOTATION", new Integer(9));
        attrTypes.put("notation", new Integer(9));
        attrTypes.put("ENUMERATED", new Integer(10));
        attrTypes.put("enumerated", new Integer(10));
    }
}

