/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util.stax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.util.NamespaceHelper;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class ElementStreamWriter
implements XMLStreamWriter {
    private Stack stack = new Stack();
    private Document document;
    private Element currentNode;
    private NamespaceContext context;
    private Map properties = new HashMap();

    public ElementStreamWriter() {
    }

    public ElementStreamWriter(Element e) {
        this.newChild(e);
    }

    public void writeStartElement(String local) throws XMLStreamException {
        this.newChild(new Element(local));
    }

    private void newChild(Element element) {
        if (this.currentNode != null) {
            this.stack.push(this.currentNode);
            this.currentNode.addContent((Content)element);
        }
        JDOMNamespaceContext context = new JDOMNamespaceContext();
        context.currentNode = element;
        this.context = context;
        this.currentNode = element;
    }

    public void writeStartElement(String namespace, String local) throws XMLStreamException {
        this.newChild(new Element(local, namespace));
    }

    public void writeStartElement(String prefix, String local, String namespace) throws XMLStreamException {
        if (prefix == null || prefix.equals("")) {
            this.writeStartElement(namespace, local);
        } else {
            this.newChild(new Element(local, prefix, namespace));
        }
    }

    public void writeEmptyElement(String namespace, String local) throws XMLStreamException {
        this.writeStartElement(namespace, local);
    }

    public void writeEmptyElement(String prefix, String namespace, String local) throws XMLStreamException {
        this.writeStartElement(prefix, namespace, local);
    }

    public void writeEmptyElement(String local) throws XMLStreamException {
        this.writeStartElement(local);
    }

    public void writeEndElement() throws XMLStreamException {
        this.currentNode = (Element)this.stack.pop();
    }

    public void writeEndDocument() throws XMLStreamException {
    }

    public void close() throws XMLStreamException {
    }

    public void flush() throws XMLStreamException {
    }

    public void writeAttribute(String local, String value) throws XMLStreamException {
        this.currentNode.setAttribute(new Attribute(local, value));
    }

    public void writeAttribute(String prefix, String namespace, String local, String value) throws XMLStreamException {
        this.currentNode.setAttribute(new Attribute(local, value, Namespace.getNamespace((String)prefix, (String)namespace)));
    }

    public void writeAttribute(String namespace, String local, String value) throws XMLStreamException {
        this.currentNode.setAttribute(new Attribute(local, value, Namespace.getNamespace((String)namespace)));
    }

    public void writeNamespace(String prefix, String namespace) throws XMLStreamException {
        Namespace decNS = this.currentNode.getNamespace(prefix);
        if (decNS != null && !decNS.getURI().equals(namespace)) {
            this.currentNode.addNamespaceDeclaration(Namespace.getNamespace((String)prefix, (String)namespace));
        }
    }

    public void writeDefaultNamespace(String namespace) throws XMLStreamException {
        this.currentNode.addNamespaceDeclaration(Namespace.getNamespace((String)"", (String)namespace));
    }

    public void writeComment(String value) throws XMLStreamException {
        this.currentNode.addContent((Content)new Comment(value));
    }

    public void writeProcessingInstruction(String arg0) throws XMLStreamException {
    }

    public void writeProcessingInstruction(String arg0, String arg1) throws XMLStreamException {
    }

    public void writeCData(String arg0) throws XMLStreamException {
    }

    public void writeDTD(String arg0) throws XMLStreamException {
    }

    public void writeEntityRef(String arg0) throws XMLStreamException {
    }

    public void writeStartDocument() throws XMLStreamException {
        this.document = new Document(new Element("root"));
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument();
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writeStartDocument();
    }

    public void writeCharacters(String text) throws XMLStreamException {
        this.currentNode.addContent(text);
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.currentNode.addContent(new String(text, start, len));
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return NamespaceHelper.getPrefix(this.currentNode, uri);
    }

    public void setPrefix(String arg0, String arg1) throws XMLStreamException {
    }

    public void setDefaultNamespace(String arg0) throws XMLStreamException {
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.context = context;
    }

    public NamespaceContext getNamespaceContext() {
        return this.context;
    }

    public Object getProperty(String prop) throws IllegalArgumentException {
        return this.properties.get(prop);
    }

    protected static class JDOMNamespaceContext
    implements NamespaceContext {
        public Element currentNode;

        protected JDOMNamespaceContext() {
        }

        public String getNamespaceURI(String prefix) {
            Namespace ns = this.currentNode.getNamespace(prefix);
            return ns != null ? ns.getURI() : null;
        }

        public String getPrefix(String uri) {
            return NamespaceHelper.getPrefix(this.currentNode, uri);
        }

        public Iterator getPrefixes(String uri) {
            ArrayList<String> prefixes = new ArrayList<String>();
            String prefix = this.getPrefix(uri);
            if (prefix != null) {
                prefixes.add(prefix);
            }
            return prefixes.iterator();
        }
    }
}

