/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util.stax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.codehaus.xfire.util.FastStack;
import org.codehaus.xfire.util.stax.DOMStreamReader;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.Text;

public class JDOMStreamReader
extends DOMStreamReader {
    private Content content;
    private FastStack namespaceStack = new FastStack();
    private List namespaces = new ArrayList();
    private Map prefix2decNs;

    public static String toStaxType(int jdom) {
        switch (jdom) {
            case 1: {
                return "CDATA";
            }
            case 2: {
                return "ID";
            }
            case 3: {
                return "IDREF";
            }
            case 4: {
                return "IDREFS";
            }
            case 5: {
                return "ENTITY";
            }
            case 6: {
                return "ENTITIES";
            }
            case 10: {
                return "ENUMERATED";
            }
            case 7: {
                return "NMTOKEN";
            }
            case 8: {
                return "NMTOKENS";
            }
            case 9: {
                return "NOTATION";
            }
        }
        return null;
    }

    public JDOMStreamReader(Element element) {
        super(new DOMStreamReader.ElementFrame(element));
        this.setupNamespaces(element);
    }

    private void setupNamespaces(Element element) {
        if (this.prefix2decNs != null) {
            this.namespaceStack.push(this.prefix2decNs);
        }
        this.prefix2decNs = new HashMap();
        this.namespaces.clear();
        Iterator itr = element.getAdditionalNamespaces().iterator();
        while (itr.hasNext()) {
            this.declare((Namespace)itr.next());
        }
        Namespace ns = element.getNamespace();
        if (this.shouldDeclare(ns)) {
            this.declare(ns);
        }
        Iterator itr2 = element.getAttributes().iterator();
        while (itr2.hasNext()) {
            ns = ((Attribute)itr2.next()).getNamespace();
            if (!this.shouldDeclare(ns)) continue;
            this.declare(ns);
        }
    }

    private void declare(Namespace ns) {
        this.prefix2decNs.put(ns.getPrefix(), ns);
        this.namespaces.add(ns);
    }

    private boolean shouldDeclare(Namespace ns) {
        if (ns == Namespace.XML_NAMESPACE) {
            return false;
        }
        if (ns == Namespace.NO_NAMESPACE && this.getDeclaredURI("") == null) {
            return false;
        }
        String decUri = this.getDeclaredURI(ns.getPrefix());
        return decUri == null || !decUri.equals(ns.getURI());
    }

    private String getDeclaredURI(String string) {
        for (int i = this.namespaceStack.size() - 1; i == 0; --i) {
            Map namespaces = (Map)this.namespaceStack.get(i);
            Namespace dec = (Namespace)namespaces.get(string);
            if (dec == null) continue;
            return dec.getURI();
        }
        return null;
    }

    protected void endElement() {
        if (this.namespaceStack.size() > 0) {
            this.prefix2decNs = (Map)this.namespaceStack.pop();
        }
    }

    public JDOMStreamReader(Document document) {
        this(document.getRootElement());
    }

    public Element getCurrentElement() {
        return (Element)this.getCurrentFrame().element;
    }

    protected DOMStreamReader.ElementFrame getChildFrame(int currentChild) {
        return new DOMStreamReader.ElementFrame(this.getCurrentElement().getContent(currentChild));
    }

    protected int getChildCount() {
        return this.getCurrentElement().getContentSize();
    }

    protected int moveToChild(int currentChild) {
        this.content = this.getCurrentElement().getContent(currentChild);
        if (this.content instanceof Text) {
            return 4;
        }
        if (this.content instanceof Element) {
            this.setupNamespaces((Element)this.content);
            return 1;
        }
        if (this.content instanceof CDATA) {
            return 4;
        }
        if (this.content instanceof Comment) {
            return 4;
        }
        if (this.content instanceof EntityRef) {
            return 9;
        }
        throw new IllegalStateException();
    }

    public String getElementText() throws XMLStreamException {
        return ((Text)this.content).getText();
    }

    public String getNamespaceURI(String prefix) {
        return this.getCurrentElement().getNamespace(prefix).getURI();
    }

    public String getAttributeValue(String ns, String local) {
        return this.getCurrentElement().getAttributeValue(local, Namespace.getNamespace((String)ns));
    }

    public int getAttributeCount() {
        return this.getCurrentElement().getAttributes().size();
    }

    Attribute getAttribute(int i) {
        return (Attribute)this.getCurrentElement().getAttributes().get(i);
    }

    public QName getAttributeName(int i) {
        Attribute at = this.getAttribute(i);
        return new QName(at.getNamespaceURI(), at.getName(), at.getNamespacePrefix());
    }

    public String getAttributeNamespace(int i) {
        return this.getAttribute(i).getNamespaceURI();
    }

    public String getAttributeLocalName(int i) {
        return this.getAttribute(i).getName();
    }

    public String getAttributePrefix(int i) {
        return this.getAttribute(i).getNamespacePrefix();
    }

    public String getAttributeType(int i) {
        return JDOMStreamReader.toStaxType(this.getAttribute(i).getAttributeType());
    }

    public String getAttributeValue(int i) {
        return this.getAttribute(i).getValue();
    }

    public boolean isAttributeSpecified(int i) {
        return this.getAttribute(i).getValue() != null;
    }

    public int getNamespaceCount() {
        return this.namespaces.size();
    }

    Namespace getNamespace(int i) {
        return (Namespace)this.namespaces.get(i);
    }

    public String getNamespacePrefix(int i) {
        return this.getNamespace(i).getPrefix();
    }

    public String getNamespaceURI(int i) {
        return this.getNamespace(i).getURI();
    }

    public NamespaceContext getNamespaceContext() {
        throw new UnsupportedOperationException();
    }

    public String getText() {
        return ((Text)this.content).getText();
    }

    public char[] getTextCharacters() {
        return this.getText().toCharArray();
    }

    public int getTextStart() {
        return 0;
    }

    public int getTextLength() {
        return this.getText().length();
    }

    public String getEncoding() {
        return null;
    }

    public QName getName() {
        Element el = this.getCurrentElement();
        return new QName(el.getNamespaceURI(), el.getName(), el.getNamespacePrefix());
    }

    public String getLocalName() {
        return this.getCurrentElement().getName();
    }

    public String getNamespaceURI() {
        return this.getCurrentElement().getNamespaceURI();
    }

    public String getPrefix() {
        return this.getCurrentElement().getNamespacePrefix();
    }

    public String getPITarget() {
        throw new UnsupportedOperationException();
    }

    public String getPIData() {
        throw new UnsupportedOperationException();
    }
}

