/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.Monitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorConverter;
import com.jamonapi.MonitorFactoryInterface;
import com.jamonapi.NullMonitor;
import com.jamonapi.TimingMonitor;
import com.jamonapi.utils.AppMap;
import com.jamonapi.utils.NodeTree;
import java.util.Collections;
import java.util.Map;

public class MonitorFactory {
    private static MonitorFactoryEnabled enabledFactory = new MonitorFactoryEnabled();
    private static MonitorFactoryDisabled disabledFactory = new MonitorFactoryDisabled();
    private static boolean debugEnabled = true;
    private static boolean enabled = true;
    private static int debugPriorityLevel = 0;

    public static MonitorComposite getComposite(String string) {
        return MonitorFactory.getFactory().getComposite(string);
    }

    public static MonitorFactoryInterface getDebugFactory() {
        return MonitorFactory.getFactory(MonitorFactory.isDebugEnabled());
    }

    public static MonitorFactoryInterface getDebugFactory(int n) {
        return MonitorFactory.getFactory(MonitorFactory.isDebugEnabled(n));
    }

    public static String getReport() throws Exception {
        return MonitorFactory.getRootMonitor().getReport();
    }

    public static String getReport(String string) throws Exception {
        return MonitorFactory.getComposite(string).getReport();
    }

    public static MonitorComposite getRootMonitor() {
        return MonitorFactory.getFactory().getRootMonitor();
    }

    public static void reset() {
        enabledFactory = new MonitorFactoryEnabled();
    }

    public static void setDebugEnabled(boolean bl) {
        debugEnabled = bl;
    }

    public static void setDebugPriorityLevel(int n) {
        debugPriorityLevel = n;
    }

    public static void setEnabled(boolean bl) {
        enabled = bl;
    }

    public static void setJAMonAdminPage(String string) {
        MonitorConverter.setJAMonAdminPage(string);
    }

    public static Monitor start(String string) {
        return MonitorFactory.getFactory().start(string);
    }

    public static Monitor start() {
        return MonitorFactory.getFactory().start();
    }

    public static Monitor startPrimary(String string) {
        return MonitorFactory.getFactory().startPrimary(string);
    }

    protected static MonitorFactoryInterface getFactory() {
        return MonitorFactory.getFactory(MonitorFactory.isEnabled());
    }

    protected static MonitorFactoryInterface getFactory(boolean bl) {
        if (bl) {
            return enabledFactory;
        }
        return disabledFactory;
    }

    protected static boolean isDebugEnabled() {
        return debugEnabled && MonitorFactory.isEnabled();
    }

    protected static boolean isDebugEnabled(int n) {
        return n >= debugPriorityLevel && MonitorFactory.isDebugEnabled();
    }

    protected static boolean isEnabled() {
        return enabled;
    }

    protected static void setNodeTree(NodeTree nodeTree) {
        enabledFactory.setNodeTree(nodeTree);
    }

    public static void main(String[] stringArray) throws Exception {
        Monitor monitor = null;
        int n = 0;
        while (n < 50) {
            monitor = MonitorFactory.start("pages/homepage");
            Thread.sleep(10);
            monitor.stop();
            Thread.sleep(10);
            ++n;
        }
        System.out.println("\nComposite test1 should be 10 ms., total 500 ms., 50 hits: " + monitor.stop());
        n = 0;
        while (n < 50) {
            monitor = MonitorFactory.start("pages.homepage");
            Thread.sleep(10);
            monitor.stop();
            Thread.sleep(10);
            ++n;
        }
        System.out.println("\nComposite test2 (Should be double the previous numbers): " + monitor.stop());
        System.out.println("\ngetting root monitor: " + MonitorFactory.getRootMonitor());
    }

    static abstract class MonitorFactoryBase
    implements MonitorFactoryInterface {
        protected MonitorComposite rootMonitor;

        public Monitor start(String string) {
            return this.createInstance(string, "def").start();
        }

        public Monitor startPrimary(String string) {
            return this.createInstance(string, "primary").start();
        }

        protected abstract Monitor createInstance(String var1, String var2);

        MonitorFactoryBase() {
        }

        public abstract Monitor start();

        public abstract MonitorComposite getComposite(String var1);

        public abstract MonitorComposite getRootMonitor();
    }

    static class MonitorFactoryEnabled
    extends MonitorFactoryBase {
        private NodeTree monitorTree;
        private Map existingLeafNodes = Collections.synchronizedMap(AppMap.createInstance());
        private TimingMonitor simpleMonitor = new TimingMonitor();

        protected MonitorFactoryEnabled() {
            this.rootMonitor = new MonitorComposite();
            this.monitorTree = new NodeTree(this.rootMonitor);
        }

        public void setNodeTree(NodeTree nodeTree) {
            this.monitorTree = nodeTree;
        }

        private boolean monitorExists(String string) {
            return this.existingLeafNodes.containsKey(string);
        }

        private Monitor getMonitor(String string) {
            TimingMonitor timingMonitor = (TimingMonitor)this.existingLeafNodes.get(string);
            return timingMonitor;
        }

        private Monitor createMonitor(String string, String string2) {
            TimingMonitor timingMonitor;
            synchronized (this) {
                timingMonitor = (TimingMonitor)this.monitorTree.getLeafNode(string, string2);
                this.existingLeafNodes.put(string, timingMonitor);
            }
            return timingMonitor;
        }

        protected Monitor createInstance(String string, String string2) {
            if (this.monitorExists(string)) {
                return this.getMonitor(string);
            }
            return this.createMonitor(string, string2);
        }

        public Monitor start() {
            return this.simpleMonitor.start();
        }

        public MonitorComposite getComposite(String string) {
            if (!this.monitorTree.compositeNodeExists(string)) {
                throw new RuntimeException("The requested MonitorComposite does not exist: " + string);
            }
            return (MonitorComposite)this.monitorTree.getCompositeNode(string);
        }

        public MonitorComposite getRootMonitor() {
            return this.rootMonitor;
        }
    }

    static class MonitorFactoryDisabled
    extends MonitorFactoryBase {
        private Monitor nullMonitor = new NullMonitor();

        protected Monitor createInstance(String string, String string2) {
            return this.nullMonitor;
        }

        public Monitor start() {
            return this.nullMonitor;
        }

        public MonitorComposite getComposite(String string) {
            return new MonitorComposite();
        }

        public MonitorComposite getRootMonitor() {
            return new MonitorComposite();
        }

        MonitorFactoryDisabled() {
        }
    }
}

