/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.AccumulateMonitor;
import com.jamonapi.ActiveStatsMonitor;
import com.jamonapi.LastAccessMonitor;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorFactory;
import com.jamonapi.TestClassPerformance;
import com.jamonapi.TimeStatsDistMonitor;
import com.jamonapi.TimeStatsMonitor;
import com.jamonapi.TimingMonitor;

public class TestClass
implements Runnable {
    static final int THREADS = 250;
    private int threadNum;
    long lobits;
    long hibits;
    AccumulateMonitor mon;

    public TestClass(int n, long l, long l2, AccumulateMonitor accumulateMonitor) {
        this.threadNum = n;
        this.lobits = l;
        this.hibits = l2;
        this.mon = accumulateMonitor;
    }

    protected TestClass() {
    }

    private static void log(Object object) {
        System.out.println("It took " + object);
    }

    public void run() {
        try {
            long l = 0L;
            if (this.threadNum % 2 == 0) {
                l = this.lobits;
                Thread.sleep(10);
            } else {
                l = this.hibits;
            }
            this.mon.increase(l);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("***** Class unit tests");
        System.out.println("\nAccumulateMonitor.main() test code - all numbers should be equal");
        AccumulateMonitor.main(null);
        System.out.println("\nTimeStatsMonitor.main()");
        TimeStatsMonitor.main(null);
        System.out.println("\nTimeStatsDistMonitor.main()");
        TimeStatsDistMonitor.main(null);
        System.out.println("\nActiveStatsMonitor.main()");
        ActiveStatsMonitor.main(null);
        System.out.println("\nTimingMonitor.main() test code - all numbers should be equal");
        TimingMonitor.main(null);
        System.out.println("\nLastAccessMonitor.main()");
        LastAccessMonitor.main(null);
        System.out.println("\nMonitorFactory.main()");
        MonitorFactory.main(null);
        TestClass testClass = new TestClass();
        System.out.println("\n***** MonitorFactory.getData():");
        Monitor monitor = MonitorFactory.start("pages.purchase.test");
        Monitor monitor2 = MonitorFactory.start("steve.souza.test");
        Thread.sleep(350);
        monitor.stop();
        Thread.sleep(650);
        monitor2.stop();
        String[][] stringArray2 = MonitorFactory.getRootMonitor().getData();
        int n = 0;
        while (n < stringArray2.length) {
            String string = "row" + n + "=[";
            int n2 = 0;
            while (n2 < stringArray2[0].length) {
                string = String.valueOf(string) + (String.valueOf(stringArray2[n][n2]) + ", ");
                ++n2;
            }
            System.out.println(String.valueOf(string) + "]");
            ++n;
        }
        System.out.println("\ncomposite tostring()=" + MonitorFactory.getRootMonitor());
        System.out.println("pages composite tostring()=" + MonitorFactory.getComposite("pages"));
        System.out.println("\n***** Multi-threaded test");
        long l = 1L;
        long l2 = 0x10000000L;
        Monitor monitor3 = MonitorFactory.start();
        ThreadGroup threadGroup = new ThreadGroup("threadGroup");
        AccumulateMonitor accumulateMonitor = new AccumulateMonitor();
        int n3 = 0;
        while (n3 < 250) {
            new Thread(threadGroup, new TestClass(n3, l, l, accumulateMonitor)).start();
            ++n3;
        }
        AccumulateMonitor accumulateMonitor2 = new AccumulateMonitor();
        int n4 = 0;
        while (n4 < 250) {
            new Thread(threadGroup, new TestClass(n4, l2, l2, accumulateMonitor2)).start();
            ++n4;
        }
        AccumulateMonitor accumulateMonitor3 = new AccumulateMonitor();
        int n5 = 0;
        while (n5 < 250) {
            new Thread(threadGroup, new TestClass(n5, l, l2, accumulateMonitor3)).start();
            ++n5;
        }
        while (threadGroup.activeCount() != 0) {
        }
        System.out.println("Threads have finished processing. It took " + monitor3.stop());
        System.out.println(String.valueOf(250) + "=" + accumulateMonitor);
        System.out.println(String.valueOf((long)250 * l2) + "=" + accumulateMonitor2);
        System.out.println(String.valueOf((long)125 * l + (long)125 * l2) + "=" + accumulateMonitor3);
        Monitor monitor4 = MonitorFactory.start("TimingMonitorThreadTest").stop();
        threadGroup = new ThreadGroup("timingMonitorThreads");
        int n6 = 0;
        while (n6 < 250) {
            new Thread(threadGroup, new TimingMonitorThreads(monitor4)).start();
            ++n6;
        }
        while (threadGroup.activeCount() != 0) {
        }
        System.out.println("hits should be " + 251 + "= " + monitor4.stop());
        System.out.println("\n***** MonitorComposite.getHeader():");
        String[] stringArray3 = MonitorComposite.getHeader();
        int n7 = 0;
        while (n7 < stringArray3.length) {
            System.out.println(stringArray3[n7]);
            ++n7;
        }
        System.out.println("\n***** MonitorFactory.getReport() 1:");
        System.out.println(MonitorFactory.getReport());
        System.out.println("\n***** MonitorFactory.getReport() 2 (after setting admin page to 'JAMon/JAMonAdmin.jsp':");
        MonitorFactory.setJAMonAdminPage("JAMon/JAMonAdmin.jsp");
        System.out.println(MonitorFactory.getReport());
        TestClassPerformance.main(stringArray);
    }

    private static class TimingMonitorThreads
    implements Runnable {
        Monitor mon;

        TimingMonitorThreads(Monitor monitor) {
            this.mon = monitor;
        }

        public void run() {
            this.mon.start().stop();
        }
    }
}

