/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.BasicTimingMonitor;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;

public class TestClassPerformance {
    private int testIterations;
    private Monitor testMon;

    public TestClassPerformance() {
        this(100000);
    }

    public TestClassPerformance(int n) {
        this.testIterations = n;
    }

    public void timingNoMonitor() throws Exception {
        System.out.println("\ntimingNoMonitor() - timing the old fashioned way with System.currentTimeMillis() (i.e.no monitors)");
        System.out.println("System.currentTimeMillis() - startTime");
        long l = 0L;
        int n = 0;
        while (n < this.testIterations) {
            l = System.currentTimeMillis() - System.currentTimeMillis() - l;
            ++n;
        }
    }

    public void basicTimingMonitor() throws Exception {
        System.out.println("\nbasicTimingMonitor() - this is the most lightweight of the Monitors");
        System.out.println("\tBasicTimingMonitor mon=new BasicTimingMonitor();");
        System.out.println("\tmon.start()");
        System.out.println("\tmon.stop()");
        BasicTimingMonitor basicTimingMonitor = new BasicTimingMonitor();
        int n = 0;
        while (n < this.testIterations) {
            basicTimingMonitor.start();
            basicTimingMonitor.stop();
            ++n;
        }
    }

    public void nullMonitor() throws Exception {
        System.out.println("\nNullMonitor() - Factory disabled so a NullMonitor is returned");
        System.out.println("\tMonitorFactory.setEnabled(false);");
        System.out.println("\tMonitor mon=MonitorFactory.start();");
        System.out.println("\tmon.stop()");
        MonitorFactory.setEnabled(false);
        int n = 0;
        while (n < this.testIterations) {
            this.testMon = MonitorFactory.start();
            this.testMon.stop();
            ++n;
        }
        MonitorFactory.setEnabled(true);
    }

    public void nullMonitor2() throws Exception {
        System.out.println("\nNullMonitor2() - Factory disabled so a NullMonitor is returned");
        System.out.println("\tMonitorFactory.setEnabled(false);");
        System.out.println("\tMonitor mon=MonitorFactory.start('pages.admin');");
        System.out.println("\tmon.stop()");
        MonitorFactory.setEnabled(false);
        int n = 0;
        while (n < this.testIterations) {
            this.testMon = MonitorFactory.start("pages.admin");
            this.testMon.stop();
            ++n;
        }
        MonitorFactory.setEnabled(true);
    }

    public void factoryBasicMonitor() throws Exception {
        System.out.println("\nbasic Factory TimingMonitor()");
        System.out.println("\tMonitor mon=MonitorFactory.start();");
        System.out.println("\tmon.stop();");
        int n = 0;
        while (n < this.testIterations) {
            this.testMon = MonitorFactory.start();
            this.testMon.stop();
            ++n;
        }
    }

    public void factoryMonitor() throws Exception {
        System.out.println("\nFull Factory TimingMonitor()- uses cached version so doesn't create child monitors");
        System.out.println("\tMonitor mon=MonitorFactory.start('pages.admin');");
        System.out.println("\tmon.stop();");
        int n = 0;
        while (n < this.testIterations) {
            this.testMon = MonitorFactory.start("pages.admin");
            this.testMon.stop();
            ++n;
        }
        System.out.println(this.testMon);
    }

    public void debugFactoryMonitor() throws Exception {
        System.out.println("\nFull Factory TimingMonitor() using debug factory - uses cached version so doesn't create child monitors");
        System.out.println("\tMonitor mon=MonitorFactory.getDebugFactory().start('pages.admin');");
        System.out.println("\tmon.stop();");
        int n = 0;
        while (n < this.testIterations) {
            this.testMon = MonitorFactory.getDebugFactory().start("pages.admin");
            this.testMon.stop();
            ++n;
        }
        System.out.println(this.testMon);
    }

    private static void log(Object object) {
        System.out.println("It took " + object);
    }

    public static void main(String[] stringArray) throws Exception {
        TestClassPerformance testClassPerformance;
        if (stringArray.length == 0) {
            testClassPerformance = new TestClassPerformance();
        } else {
            int n = Integer.parseInt(stringArray[0]);
            testClassPerformance = new TestClassPerformance(n);
        }
        System.out.println("\n***** Performance Tests:");
        System.out.println("All performance code loops " + testClassPerformance.testIterations + " times");
        Monitor monitor = MonitorFactory.start();
        Monitor monitor2 = MonitorFactory.start();
        testClassPerformance.timingNoMonitor();
        TestClassPerformance.log(monitor2.stop());
        monitor2 = MonitorFactory.start();
        testClassPerformance.basicTimingMonitor();
        TestClassPerformance.log(monitor2.stop());
        monitor2 = MonitorFactory.start();
        testClassPerformance.nullMonitor();
        TestClassPerformance.log(monitor2.stop());
        monitor2 = MonitorFactory.start();
        testClassPerformance.nullMonitor2();
        TestClassPerformance.log(monitor2.stop());
        monitor2 = MonitorFactory.start();
        testClassPerformance.factoryBasicMonitor();
        TestClassPerformance.log(monitor2.stop());
        monitor2 = MonitorFactory.start();
        testClassPerformance.debugFactoryMonitor();
        TestClassPerformance.log(monitor2.stop());
        monitor2 = MonitorFactory.start();
        testClassPerformance.factoryMonitor();
        TestClassPerformance.log(monitor2.stop());
        System.out.println("\nExecuting full factory monitors a second time.  The second time reflects performance characteristics more accurately");
        monitor2 = MonitorFactory.start();
        testClassPerformance.debugFactoryMonitor();
        TestClassPerformance.log(monitor2.stop());
        monitor2 = MonitorFactory.start();
        testClassPerformance.factoryMonitor();
        TestClassPerformance.log(monitor2.stop());
        System.out.println("\n***** Total time for performance tests were: " + monitor.stop());
    }
}

