/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.utils;

import java.util.Arrays;

class ArraySorter {
    private Object[][] array;
    int sortCol;
    String sortOrder;
    static final Float zero = new Float(0.0f);

    private static void display(Object[][] objectArray) {
        int n = objectArray.length;
        int n2 = objectArray[0].length;
        int n3 = 0;
        while (n3 < n) {
            String string = "";
            int n4 = 0;
            while (n4 < n2) {
                string = String.valueOf(string) + (String.valueOf(objectArray[n3][n4]) + " ");
                ++n4;
            }
            System.out.println(string);
            ++n3;
        }
    }

    public ArraySorter(Object[][] objectArray, int n, String string) {
        this.array = objectArray;
        this.sortCol = n;
        this.sortOrder = string;
    }

    private int getRows() {
        return this.array.length;
    }

    private int getCols() {
        return this.array[0].length;
    }

    private Object[] getArrayToSort() {
        Object[] objectArray = new Object[this.getRows()];
        int n = 0;
        while (n < this.getRows()) {
            objectArray[n] = this.array[n];
            ++n;
        }
        return objectArray;
    }

    private ArraySorterEntry[] getArraySorterEntries() {
        Object[] objectArray = this.getArrayToSort();
        ArraySorterEntry[] arraySorterEntryArray = new ArraySorterEntry[this.getRows()];
        int n = 0;
        while (n < this.getRows()) {
            arraySorterEntryArray[n] = new ArraySorterEntry(objectArray[n], (Comparable)this.array[n][this.sortCol]);
            ++n;
        }
        return arraySorterEntryArray;
    }

    public Object[][] sort() {
        Object[] objectArray = this.getArraySorterEntries();
        Arrays.sort(objectArray);
        Object[][] objectArray2 = new Object[this.getRows()][this.getCols()];
        int n = 0;
        while (n < this.getRows()) {
            objectArray2[n] = (Object[])((ArraySorterEntry)objectArray[n]).getSortedObject();
            ++n;
        }
        return objectArray2;
    }

    public static void main(String[] stringArray) throws Exception {
        Object[][] objectArray = new Object[][]{{"7", "8", "9"}, {"1", "2", "3"}, {"4", "5", "6"}};
        System.out.println("unsorted array");
        ArraySorter.display(objectArray);
        System.out.println("sorted array: asc on col 0");
        ArraySorter arraySorter = new ArraySorter(objectArray, 0, "asc");
        ArraySorter.display(arraySorter.sort());
        System.out.println("sorted array: desc on col 0");
        arraySorter = new ArraySorter(objectArray, 0, "desc");
        ArraySorter.display(arraySorter.sort());
        System.out.println("sorted array invalid - RuntimeException will be thrown");
        arraySorter = new ArraySorter(objectArray, 0, "invalid");
        ArraySorter.display(arraySorter.sort());
    }

    private final class ArraySorterEntry
    implements Comparable {
        private Object arrayValueToSort;
        private Comparable valueToSortBy;

        public ArraySorterEntry(Object object, Comparable comparable) {
            this.arrayValueToSort = object;
            this.valueToSortBy = this.convert((String)((Object)comparable));
        }

        private Comparable convert(String string) {
            if (ArraySorter.this.sortCol >= 1 && ArraySorter.this.sortCol <= 9) {
                return Float.valueOf(string.replace(',', '0'));
            }
            if (ArraySorter.this.sortCol >= 13) {
                int n = string.indexOf("/");
                if (n == -1) {
                    return zero;
                }
                return Float.valueOf(string.substring(0, n).replace(',', '0'));
            }
            return string;
        }

        public int compareTo(Object object) {
            ArraySorterEntry arraySorterEntry = (ArraySorterEntry)object;
            int n = this.valueToSortBy.compareTo(arraySorterEntry.valueToSortBy);
            if (n == 0 || "asc".equalsIgnoreCase(ArraySorter.this.sortOrder)) {
                return n;
            }
            if ("desc".equalsIgnoreCase(ArraySorter.this.sortOrder)) {
                return -n;
            }
            throw new RuntimeException("Programming error: The only valid sort orders are 'asc' and 'desc', but '" + ArraySorter.this.sortOrder + "' was passed");
        }

        public Object getSortedObject() {
            return this.arrayValueToSort;
        }
    }
}

