/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.JaxenRuntimeException;
import org.jaxen.Navigator;
import org.jaxen.UnsupportedAxisException;

public class StringFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        int size = args.size();
        if (size == 0) {
            return StringFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (size == 1) {
            return StringFunction.evaluate(args.get(0), context.getNavigator());
        }
        throw new FunctionCallException("string() requires one argument.");
    }

    public static String evaluate(Object obj, Navigator nav) {
        try {
            String retval = "";
            if (obj == null) {
                return "";
            }
            if (obj instanceof List) {
                List list = (List)obj;
                if (list.isEmpty()) {
                    return "";
                }
                obj = list.get(0);
            }
            if (nav != null && (nav.isElement(obj) || nav.isDocument(obj))) {
                Iterator descendantAxisIterator = nav.getDescendantAxisIterator(obj);
                StringBuffer sb = new StringBuffer();
                while (descendantAxisIterator.hasNext()) {
                    Object descendant = descendantAxisIterator.next();
                    if (!nav.isText(descendant)) continue;
                    sb.append(nav.getTextStringValue(descendant));
                }
                retval = sb.toString();
            } else if (nav != null && nav.isAttribute(obj)) {
                retval = nav.getAttributeStringValue(obj);
            } else if (nav != null && nav.isText(obj)) {
                retval = nav.getTextStringValue(obj);
            } else if (nav != null && nav.isProcessingInstruction(obj)) {
                retval = nav.getProcessingInstructionData(obj);
            } else if (nav != null && nav.isComment(obj)) {
                retval = nav.getCommentStringValue(obj);
            } else if (nav != null && nav.isNamespace(obj)) {
                retval = nav.getNamespaceStringValue(obj);
            } else if (obj instanceof String) {
                retval = (String)obj;
            } else if (obj instanceof Boolean) {
                retval = StringFunction.stringValue((Boolean)obj);
            } else if (obj instanceof Number) {
                retval = StringFunction.stringValue(((Number)obj).doubleValue());
            }
            retval = retval == null ? "" : retval;
            return retval;
        }
        catch (UnsupportedAxisException e) {
            throw new JaxenRuntimeException(e);
        }
    }

    public static String stringValue(double value) {
        if (Double.isNaN(value)) {
            return "NaN";
        }
        if (-0.0 == value || 0.0 == value) {
            return "0";
        }
        if (Double.isInfinite(value) && value < 0.0) {
            return "-Infinity";
        }
        if (Double.isInfinite(value) && value > 0.0) {
            return "Infinity";
        }
        if ((double)((long)value) == value) {
            return Long.toString((long)value);
        }
        return Double.toString(value);
    }

    public static String stringValue(boolean bool) {
        return bool ? "true" : "false";
    }
}

