/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.Iterator;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.DocumentFragment;
import nu.xom.Element;
import nu.xom.JaxenConnector;
import nu.xom.JaxenNavigator;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.XPathContext;
import nu.xom.XPathException;
import org.jaxen.JaxenException;

public abstract class Node {
    private ParentNode parent = null;

    Node() {
    }

    public abstract String getValue();

    public final Document getDocument() {
        Node node;
        for (node = this; node != null && !node.isDocument(); node = node.getParent()) {
        }
        return (Document)node;
    }

    final Node getRoot() {
        ParentNode parentNode = this.getParent();
        if (parentNode == null) {
            return this;
        }
        while (parentNode.getParent() != null) {
            parentNode = parentNode.getParent();
        }
        return parentNode;
    }

    public String getBaseURI() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.getBaseURI();
    }

    public final ParentNode getParent() {
        return this.parent;
    }

    final void setParent(ParentNode parentNode) {
        this.parent = parentNode;
    }

    public void detach() {
        if (this.parent == null) {
            return;
        }
        if (this.isAttribute()) {
            Element element = (Element)this.parent;
            element.removeAttribute((Attribute)this);
        } else {
            this.parent.removeChild(this);
        }
    }

    public abstract Node getChild(int var1);

    public abstract int getChildCount();

    public abstract Node copy();

    public abstract String toXML();

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final Nodes query(String string, XPathContext xPathContext) {
        if (this.isDocType()) {
            throw new XPathException("Can't use XPath on a DocType");
        }
        DocumentFragment documentFragment = null;
        Node node = this.getRoot();
        if (!node.isDocument()) {
            documentFragment = new DocumentFragment();
            documentFragment.appendChild(node);
        }
        try {
            Object object;
            JaxenConnector jaxenConnector = new JaxenConnector(string);
            if (xPathContext != null) {
                jaxenConnector.setNamespaceContext(xPathContext.getJaxenContext());
            }
            List list = jaxenConnector.selectNodes(this);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object instanceof JaxenNavigator.XPathNamespaceNode) {
                    throw new XPathException("XPath expression " + string + "returned namespace nodes, which XOM " + "does not support.");
                }
                if (object instanceof DocumentFragment) {
                    iterator.remove();
                    if (!list.isEmpty()) continue;
                    throw new XPathException("Tried to get document node of disconnected subtree");
                }
                if (object instanceof Node) continue;
                throw new XPathException("XPath expression " + string + " did not return a node-set.");
            }
            object = this.sortResults(list);
            return object;
        }
        catch (XPathException xPathException) {
            xPathException.setXPath(string);
            throw xPathException;
        }
        catch (JaxenException jaxenException) {
            XPathException xPathException = new XPathException("XPath error: " + jaxenException.getMessage(), jaxenException);
            xPathException.setXPath(string);
            throw xPathException;
        }
        catch (RuntimeException runtimeException) {
            XPathException xPathException = new XPathException("XPath error: " + runtimeException.getMessage(), runtimeException);
            xPathException.setXPath(string);
            throw xPathException;
        }
        finally {
            if (documentFragment != null) {
                documentFragment.removeChild(0);
            }
        }
    }

    private Nodes sortResults(List list) {
        Node node = this.getRoot();
        if (list.size() > 1 && node instanceof ParentNode) {
            Nodes nodes = new Nodes();
            Node.process(list, nodes, (ParentNode)node);
            return nodes;
        }
        return new Nodes(list);
    }

    private static void process(List list, Nodes nodes, ParentNode parentNode) {
        if (list.isEmpty()) {
            return;
        }
        if (list.contains(parentNode)) {
            nodes.append(parentNode);
            list.remove(parentNode);
            if (list.isEmpty()) {
                return;
            }
        }
        int n = parentNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            Node node = parentNode.getChild(i);
            if (node.isElement()) {
                Element element = (Element)node;
                for (int j = 0; j < element.getAttributeCount(); ++j) {
                    Attribute attribute = element.getAttribute(j);
                    if (!list.contains(attribute)) continue;
                    nodes.append(attribute);
                    list.remove(attribute);
                    if (!list.isEmpty()) continue;
                    return;
                }
                Node.process(list, nodes, element);
                continue;
            }
            if (!list.contains(node)) continue;
            nodes.append(node);
            list.remove(node);
            if (!list.isEmpty()) continue;
            return;
        }
    }

    public final Nodes query(String string) {
        return this.query(string, null);
    }

    boolean isElement() {
        return false;
    }

    boolean isText() {
        return false;
    }

    boolean isComment() {
        return false;
    }

    boolean isProcessingInstruction() {
        return false;
    }

    boolean isAttribute() {
        return false;
    }

    boolean isDocument() {
        return false;
    }

    boolean isDocType() {
        return false;
    }
}

