/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.CollectionFactory;

class BeanDefinitionValueResolver {
    public static final String GENERATED_BEAN_NAME_SEPARATOR = "#";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final AbstractBeanFactory beanFactory;
    private final String beanName;
    private final BeanDefinition beanDefinition;

    public BeanDefinitionValueResolver(AbstractBeanFactory beanFactory, String beanName, BeanDefinition beanDefinition) {
        this.beanName = beanName;
        this.beanDefinition = beanDefinition;
        this.beanFactory = beanFactory;
    }

    public Object resolveValueIfNecessary(String argName, Object value) throws BeansException {
        if (value instanceof BeanDefinitionHolder) {
            BeanDefinitionHolder bdHolder = (BeanDefinitionHolder)value;
            return this.resolveInnerBeanDefinition(argName, bdHolder.getBeanName(), bdHolder.getBeanDefinition());
        }
        if (value instanceof BeanDefinition) {
            BeanDefinition bd = (BeanDefinition)value;
            return this.resolveInnerBeanDefinition(argName, "(inner bean)", bd);
        }
        if (value instanceof RuntimeBeanReference) {
            RuntimeBeanReference ref = (RuntimeBeanReference)value;
            return this.resolveReference(argName, ref);
        }
        if (value instanceof ManagedList) {
            return this.resolveManagedList(argName, (List)value);
        }
        if (value instanceof ManagedSet) {
            return this.resolveManagedSet(argName, (Set)value);
        }
        if (value instanceof ManagedMap) {
            return this.resolveManagedMap(argName, (Map)value);
        }
        if (value instanceof ManagedProperties) {
            Properties copy = new Properties();
            copy.putAll((Map<?, ?>)((Properties)value));
            return copy;
        }
        if (value instanceof TypedStringValue) {
            TypedStringValue typedStringValue = (TypedStringValue)value;
            try {
                return this.beanFactory.doTypeConversionIfNecessary(typedStringValue.getValue(), typedStringValue.getTargetType());
            }
            catch (TypeMismatchException ex) {
                throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Error converting typed String value for " + argName, (Throwable)((Object)ex));
            }
        }
        return value;
    }

    private Object resolveInnerBeanDefinition(String argName, String innerBeanName, BeanDefinition innerBd) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolving inner bean definition '" + innerBeanName + "' of bean '" + this.beanName + "'"));
        }
        try {
            RootBeanDefinition mergedInnerBd = this.beanFactory.getMergedBeanDefinition(innerBeanName, innerBd);
            String actualInnerBeanName = this.adaptInnerBeanName(innerBeanName);
            Object innerBean = this.beanFactory.createBean(actualInnerBeanName, mergedInnerBd, null);
            if (mergedInnerBd.isSingleton()) {
                this.beanFactory.registerDependentBean(actualInnerBeanName, this.beanName);
            }
            return this.beanFactory.getObjectForBeanInstance(innerBean, actualInnerBeanName, false);
        }
        catch (BeansException ex) {
            throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Cannot create inner bean '" + innerBeanName + "' while setting " + argName, (Throwable)((Object)ex));
        }
    }

    private String adaptInnerBeanName(String innerBeanName) {
        String actualInnerBeanName = innerBeanName;
        int counter = 0;
        while (this.beanFactory.isBeanNameUsed(actualInnerBeanName)) {
            actualInnerBeanName = innerBeanName + GENERATED_BEAN_NAME_SEPARATOR + ++counter;
        }
        return actualInnerBeanName;
    }

    private Object resolveReference(String argName, RuntimeBeanReference ref) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolving reference from property '" + argName + "' in bean '" + this.beanName + "' to bean '" + ref.getBeanName() + "'"));
        }
        try {
            if (ref.isToParent()) {
                if (this.beanFactory.getParentBeanFactory() == null) {
                    throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Can't resolve reference to bean '" + ref.getBeanName() + "' in parent factory: no parent factory available");
                }
                return this.beanFactory.getParentBeanFactory().getBean(ref.getBeanName());
            }
            if (this.beanDefinition.isSingleton()) {
                this.beanFactory.registerDependentBean(ref.getBeanName(), this.beanName);
            }
            return this.beanFactory.getBean(ref.getBeanName());
        }
        catch (BeansException ex) {
            throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Cannot resolve reference to bean '" + ref.getBeanName() + "' while setting " + argName, (Throwable)((Object)ex));
        }
    }

    private List resolveManagedList(String argName, List ml) throws BeansException {
        ArrayList<Object> resolved = new ArrayList<Object>(ml.size());
        for (int i = 0; i < ml.size(); ++i) {
            resolved.add(this.resolveValueIfNecessary(argName + " with key " + "[" + i + "]", ml.get(i)));
        }
        return resolved;
    }

    private Set resolveManagedSet(String argName, Set ms) throws BeansException {
        Set resolved = CollectionFactory.createLinkedSetIfPossible((int)ms.size());
        int i = 0;
        Iterator it = ms.iterator();
        while (it.hasNext()) {
            resolved.add(this.resolveValueIfNecessary(argName + " with key " + "[" + i + "]", it.next()));
            ++i;
        }
        return resolved;
    }

    private Map resolveManagedMap(String argName, Map mm) throws BeansException {
        Map resolved = CollectionFactory.createLinkedMapIfPossible((int)mm.size());
        Iterator it = mm.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object resolvedKey = this.resolveValueIfNecessary(argName, entry.getKey());
            Object resolvedValue = this.resolveValueIfNecessary(argName + " with key " + "[" + entry.getKey() + "]", entry.getValue());
            resolved.put(resolvedKey, resolvedValue);
        }
        return resolved;
    }
}

