/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.serversession;

import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.springframework.jms.listener.serversession.ServerSessionMessageListenerContainer;

public class ServerSessionMessageListenerContainer102
extends ServerSessionMessageListenerContainer {
    protected Connection createConnection() throws JMSException {
        if (this.isPubSubDomain()) {
            return ((TopicConnectionFactory)this.getConnectionFactory()).createTopicConnection();
        }
        return ((QueueConnectionFactory)this.getConnectionFactory()).createQueueConnection();
    }

    protected ConnectionConsumer createConsumer(Connection con, Destination destination, ServerSessionPool pool) throws JMSException {
        if (this.isPubSubDomain()) {
            return ((TopicConnection)con).createConnectionConsumer((Topic)destination, this.getMessageSelector(), pool, this.getMaxMessagesPerTask());
        }
        return ((QueueConnection)con).createConnectionConsumer((Queue)destination, this.getMessageSelector(), pool, this.getMaxMessagesPerTask());
    }

    protected Session createSession(Connection con) throws JMSException {
        if (this.isPubSubDomain()) {
            return ((TopicConnection)con).createTopicSession(this.isSessionTransacted(), this.getSessionAcknowledgeMode());
        }
        return ((QueueConnection)con).createQueueSession(this.isSessionTransacted(), this.getSessionAcknowledgeMode());
    }

    protected boolean isClientAcknowledge(Session session) throws JMSException {
        return this.getSessionAcknowledgeMode() == 2;
    }
}

