/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.config;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.config.NamespaceHandlerUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ConfigBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ASPECT = "aspect";
    private static final String EXPRESSION = "expression";
    private static final String ID = "id";
    private static final String POINTCUT = "pointcut";
    private static final String ADVICE = "advice";
    private static final String ADVISOR = "advisor";
    private static final String ADVICE_REF = "advice-ref";
    private static final String POINTCUT_REF = "pointcut-ref";
    private static final String REF = "ref";
    private static final String KIND = "kind";
    private static final String BEFORE = "before";
    private static final String DECLARE_PARENTS = "declare-parents";
    private static final String TYPE_PATTERN = "types-matching";
    private static final String DEFAULT_IMPL = "default-impl";
    private static final String IMPLEMENT_INTERFACE = "implement-interface";
    private static final String AFTER = "after";
    private static final String AFTER_RETURNING = "afterReturning";
    private static final String AFTER_THROWING = "afterThrowing";
    private static final String AFTER_RETURNING_ELEMENT = "after-returning";
    private static final String AFTER_THROWING_ELEMENT = "after-throwing";
    private static final String AROUND = "around";
    private static final String PROXY_TARGET_CLASS = "proxy-target-class";
    private static final String TRUE = "true";
    private static final String RETURNING = "returning";
    private static final String RETURNING_PROPERTY = "returningName";
    private static final String THROWING = "throwing";
    private static final String THROWING_PROPERTY = "throwingName";
    private static final String ARG_NAMES = "arg-names";
    private static final String ARG_NAMES_PROPERTY = "argumentNames";
    private static final String ASPECT_NAME_PROPERTY = "aspectName";
    private static final String ASPECT_BEAN_PROPERTY = "aspectBean";
    private static final String DECLARATION_ORDER_PROPERTY = "declarationOrder";
    private static final String ORDER_PROPERTY = "order";
    private static final int METHOD_INDEX = 0;
    private static final int POINTCUT_INDEX = 1;
    private static final int ASPECT_INSTANCE_FACTORY_INDEX = 2;
    private static final int PARAMETER_NAME_DISCOVERER = 3;
    private static final String ADVICE_DEPRECATION_MESSAGE = "The element <aop:advice> is deprecated in Spring 2.0 M3 in favour of the advice type specific forms <aop:before>, <aop:after-returning>, <aop:after-throwing>, <aop:after>, and <aop:around>. Please update your configuration files before the next milestone build, when support for <aop:advice> will be removed.";
    private final Log logger = LogFactory.getLog(this.getClass());
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJPointcutAdvisor;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$DeclareParentsAdvisor;
    static /* synthetic */ Class class$java$lang$reflect$Field;
    static /* synthetic */ Class class$org$springframework$aop$config$MethodLocatingFactoryBean;
    static /* synthetic */ Class class$org$springframework$aop$config$BeanFactoryAspectInstanceFactory;
    static /* synthetic */ Class class$org$springframework$core$PrioritizedParameterNameDiscoverer;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAfterAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAroundAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJExpressionPointcut;

    ConfigBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        ParseContext parseContext = new ParseContext();
        NodeList childNodes = element.getChildNodes();
        NamespaceHandlerUtils.registerAspectJAutoProxyCreatorIfNecessary(registry);
        boolean proxyTargetClass = TRUE.equals(element.getAttribute(PROXY_TARGET_CLASS));
        if (proxyTargetClass) {
            NamespaceHandlerUtils.forceAutoProxyCreatorToUseClassProxying(registry);
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            String localName = node.getLocalName();
            if (POINTCUT.equals(localName)) {
                this.parsePointcut((Element)node, registry, true);
                continue;
            }
            if (ADVISOR.equals(localName)) {
                this.parseAdvisor((Element)node, registry, parseContext);
                continue;
            }
            if (!ASPECT.equals(localName)) continue;
            this.parseAspect((Element)node, registry, parseContext);
        }
        return null;
    }

    private void parsePointcut(Element pointcutElement, BeanDefinitionRegistry registry, boolean asPrototype) {
        BeanDefinition pointcutDefinition = this.createPointcutDefinition(pointcutElement.getAttribute(EXPRESSION), asPrototype);
        String id = pointcutElement.getAttribute(ID);
        if (!StringUtils.hasText((String)id)) {
            id = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)((AbstractBeanDefinition)pointcutDefinition), (BeanDefinitionRegistry)registry, (boolean)false);
        }
        registry.registerBeanDefinition(id, pointcutDefinition);
    }

    private void parseAdvisor(Element element, BeanDefinitionRegistry registry, ParseContext parseContext) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(class$org$springframework$aop$aspectj$AspectJPointcutAdvisor == null ? (class$org$springframework$aop$aspectj$AspectJPointcutAdvisor = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJPointcutAdvisor")) : class$org$springframework$aop$aspectj$AspectJPointcutAdvisor);
        MutablePropertyValues mpvs = new MutablePropertyValues();
        if (element.hasAttribute(ORDER_PROPERTY)) {
            mpvs.addPropertyValue(ORDER_PROPERTY, (Object)element.getAttribute(ORDER_PROPERTY));
        }
        beanDefinition.setPropertyValues(mpvs);
        mpvs.addPropertyValue(ADVICE, (Object)new RuntimeBeanReference(element.getAttribute(ADVICE_REF)));
        this.parsePointcutProperty(element, mpvs, registry);
        String id = element.getAttribute(ID);
        if (!StringUtils.hasText((String)id)) {
            id = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry, (boolean)false);
        }
        registry.registerBeanDefinition(id, (BeanDefinition)beanDefinition);
    }

    private void parseAspect(Element aspectElement, BeanDefinitionRegistry registry, ParseContext parseContext) {
        String aspectName = aspectElement.getAttribute(REF);
        List pointcuts = DomUtils.getChildElementsByTagName((Element)aspectElement, (String)POINTCUT);
        for (int i = 0; i < pointcuts.size(); ++i) {
            Element pointcutElement = (Element)pointcuts.get(i);
            this.parsePointcut(pointcutElement, registry, true);
        }
        List declareParents = DomUtils.getChildElementsByTagName((Element)aspectElement, (String)DECLARE_PARENTS);
        for (int i = 0; i < declareParents.size(); ++i) {
            Element declareParentsElement = (Element)declareParents.get(i);
            this.parseDeclareParents(aspectName, declareParentsElement, new BeanDefinitionRegistryBuilder(registry), parseContext);
        }
        NodeList nodeList = aspectElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!this.isAdviceNode(node)) continue;
            this.parseAdvice(aspectName, i, (Element)node, registry, parseContext);
        }
    }

    private boolean isAdviceNode(Node aNode) {
        if (!(aNode instanceof Element)) {
            return false;
        }
        String name = aNode.getLocalName();
        return ADVICE.equals(name) || BEFORE.equals(name) || AFTER.equals(name) || AFTER_RETURNING_ELEMENT.equals(name) || AFTER_THROWING_ELEMENT.equals(name) || AROUND.equals(name);
    }

    private void parseDeclareParents(String aspectName, Element declareParentsElement, BeanDefinitionRegistryBuilder registryBuilder, ParseContext parseContext) {
        registryBuilder.register(BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$aop$aspectj$DeclareParentsAdvisor == null ? (class$org$springframework$aop$aspectj$DeclareParentsAdvisor = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.DeclareParentsAdvisor")) : class$org$springframework$aop$aspectj$DeclareParentsAdvisor)).addConstructorArg((Object)declareParentsElement.getAttribute(IMPLEMENT_INTERFACE)).addConstructorArg((Object)declareParentsElement.getAttribute(TYPE_PATTERN)).addConstructorArg((Object)declareParentsElement.getAttribute(DEFAULT_IMPL)));
    }

    private void parseAdvice(String aspectName, int order, Element adviceElement, BeanDefinitionRegistry registry, ParseContext parseContext) {
        MutablePropertyValues advisorProperties = new MutablePropertyValues();
        String pointcutBeanName = this.parsePointcutProperty(adviceElement, advisorProperties, registry);
        RootBeanDefinition methodDefinition = new RootBeanDefinition(class$org$springframework$aop$config$MethodLocatingFactoryBean == null ? (class$org$springframework$aop$config$MethodLocatingFactoryBean = ConfigBeanDefinitionParser.class$("org.springframework.aop.config.MethodLocatingFactoryBean")) : class$org$springframework$aop$config$MethodLocatingFactoryBean);
        methodDefinition.getPropertyValues().addPropertyValue("targetBeanName", (Object)aspectName);
        methodDefinition.getPropertyValues().addPropertyValue("methodName", (Object)adviceElement.getAttribute("method"));
        RootBeanDefinition instanceFactoryDefinition = new RootBeanDefinition(class$org$springframework$aop$config$BeanFactoryAspectInstanceFactory == null ? (class$org$springframework$aop$config$BeanFactoryAspectInstanceFactory = ConfigBeanDefinitionParser.class$("org.springframework.aop.config.BeanFactoryAspectInstanceFactory")) : class$org$springframework$aop$config$BeanFactoryAspectInstanceFactory);
        instanceFactoryDefinition.getPropertyValues().addPropertyValue("aspectBeanName", (Object)aspectName);
        RootBeanDefinition adviceDefinition = null;
        boolean isAroundAdvice = false;
        if (adviceElement.hasAttribute(KIND)) {
            this.logger.warn((Object)ADVICE_DEPRECATION_MESSAGE);
            String kind = adviceElement.getAttribute(KIND);
            adviceDefinition = new RootBeanDefinition(this.getAdviceClass(kind));
            isAroundAdvice = AROUND.equals(kind);
        } else {
            adviceDefinition = new RootBeanDefinition(this.getAdviceClass(adviceElement));
            isAroundAdvice = AROUND.equals(adviceElement.getLocalName());
        }
        adviceDefinition.getPropertyValues().addPropertyValue(ASPECT_NAME_PROPERTY, (Object)aspectName);
        adviceDefinition.getPropertyValues().addPropertyValue(ASPECT_BEAN_PROPERTY, (Object)new RuntimeBeanReference(aspectName));
        adviceDefinition.getPropertyValues().addPropertyValue(DECLARATION_ORDER_PROPERTY, (Object)new Integer(order));
        if (adviceElement.hasAttribute(RETURNING)) {
            adviceDefinition.getPropertyValues().addPropertyValue(RETURNING_PROPERTY, (Object)adviceElement.getAttribute(RETURNING));
        }
        if (adviceElement.hasAttribute(THROWING)) {
            adviceDefinition.getPropertyValues().addPropertyValue(THROWING_PROPERTY, (Object)adviceElement.getAttribute(THROWING));
        }
        if (adviceElement.hasAttribute(ARG_NAMES)) {
            adviceDefinition.getPropertyValues().addPropertyValue(ARG_NAMES_PROPERTY, (Object)adviceElement.getAttribute(ARG_NAMES));
        }
        ConstructorArgumentValues cav = new ConstructorArgumentValues();
        cav.addIndexedArgumentValue(0, (Object)methodDefinition);
        cav.addIndexedArgumentValue(1, (Object)new RuntimeBeanReference(pointcutBeanName));
        cav.addIndexedArgumentValue(2, (Object)instanceFactoryDefinition);
        if (isAroundAdvice) {
            this.extendAdviceConstructorArgs(cav);
        }
        adviceDefinition.setConstructorArgumentValues(cav);
        RootBeanDefinition advisorDefinition = new RootBeanDefinition(class$org$springframework$aop$aspectj$AspectJPointcutAdvisor == null ? (class$org$springframework$aop$aspectj$AspectJPointcutAdvisor = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJPointcutAdvisor")) : class$org$springframework$aop$aspectj$AspectJPointcutAdvisor);
        advisorDefinition.setPropertyValues(advisorProperties);
        advisorDefinition.getPropertyValues().addPropertyValue(ADVICE, (Object)adviceDefinition);
        String id = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)advisorDefinition, (BeanDefinitionRegistry)registry, (boolean)false);
        registry.registerBeanDefinition(id, (BeanDefinition)advisorDefinition);
    }

    private void extendAdviceConstructorArgs(ConstructorArgumentValues cav) {
        RootBeanDefinition discovererDefinition = new RootBeanDefinition(class$org$springframework$core$PrioritizedParameterNameDiscoverer == null ? (class$org$springframework$core$PrioritizedParameterNameDiscoverer = ConfigBeanDefinitionParser.class$("org.springframework.core.PrioritizedParameterNameDiscoverer")) : class$org$springframework$core$PrioritizedParameterNameDiscoverer);
        cav.addIndexedArgumentValue(3, (Object)discovererDefinition);
    }

    private Class getAdviceClass(String kind) {
        if (BEFORE.equals(kind)) {
            return class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice == null ? (class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJMethodBeforeAdvice")) : class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice;
        }
        if (AFTER.equals(kind)) {
            return class$org$springframework$aop$aspectj$AspectJAfterAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJAfterAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterAdvice;
        }
        if (AFTER_RETURNING.equals(kind)) {
            return class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJAfterReturningAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice;
        }
        if (AFTER_THROWING.equals(kind)) {
            return class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJAfterThrowingAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice;
        }
        if (AROUND.equals(kind)) {
            return class$org$springframework$aop$aspectj$AspectJAroundAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAroundAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJAroundAdvice")) : class$org$springframework$aop$aspectj$AspectJAroundAdvice;
        }
        throw new IllegalArgumentException("Unknown advice kind [" + kind + "].");
    }

    private Class getAdviceClass(Element adviceElement) {
        String elementName = adviceElement.getLocalName();
        if (BEFORE.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice == null ? (class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJMethodBeforeAdvice")) : class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice;
        }
        if (AFTER.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJAfterAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJAfterAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterAdvice;
        }
        if (AFTER_RETURNING_ELEMENT.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJAfterReturningAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice;
        }
        if (AFTER_THROWING_ELEMENT.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJAfterThrowingAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice;
        }
        if (AROUND.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJAroundAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAroundAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJAroundAdvice")) : class$org$springframework$aop$aspectj$AspectJAroundAdvice;
        }
        throw new IllegalArgumentException("Unknown advice kind [" + elementName + "].");
    }

    private String parsePointcutProperty(Element element, MutablePropertyValues mpvs, BeanDefinitionRegistry registry) {
        if (element.hasAttribute(POINTCUT) && element.hasAttribute(POINTCUT_REF)) {
            throw new IllegalStateException("Cannot define both 'pointcut' and 'pointcut-ref' on 'advisor' tag.");
        }
        if (element.hasAttribute(POINTCUT)) {
            BeanDefinition pointcutDefinition = this.createPointcutDefinition(element.getAttribute(POINTCUT), false);
            String pointcutName = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)((AbstractBeanDefinition)pointcutDefinition), (BeanDefinitionRegistry)registry, (boolean)false);
            registry.registerBeanDefinition(pointcutName, pointcutDefinition);
            mpvs.addPropertyValue(POINTCUT, (Object)new RuntimeBeanReference(pointcutName));
            return pointcutName;
        }
        if (element.hasAttribute(POINTCUT_REF)) {
            String pointcutRef = element.getAttribute(POINTCUT_REF);
            mpvs.addPropertyValue(POINTCUT, (Object)new RuntimeBeanReference(pointcutRef));
            return pointcutRef;
        }
        throw new IllegalStateException("Must define one of 'pointcut' or 'pointcut-ref' on 'advisor'.");
    }

    protected BeanDefinition createPointcutDefinition(String expression, boolean asPrototype) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(class$org$springframework$aop$aspectj$AspectJExpressionPointcut == null ? (class$org$springframework$aop$aspectj$AspectJExpressionPointcut = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJExpressionPointcut")) : class$org$springframework$aop$aspectj$AspectJExpressionPointcut);
        if (asPrototype) {
            beanDefinition.setSingleton(false);
        }
        beanDefinition.setPropertyValues(new MutablePropertyValues());
        beanDefinition.getPropertyValues().addPropertyValue(EXPRESSION, (Object)expression);
        return beanDefinition;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class FieldLocatingFactoryBean
    implements FactoryBean,
    BeanFactoryAware {
        private Field f;
        private String beanName;
        private String fieldName;

        public FieldLocatingFactoryBean(String beanName, String fieldName) {
            this.beanName = beanName;
            this.fieldName = fieldName;
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            Class beanClass = beanFactory.getType(this.beanName);
            if (beanClass == null) {
                throw new IllegalArgumentException("Can't determine type of bean with name '" + this.beanName + "'");
            }
            try {
                this.f = beanClass.getDeclaredField(this.fieldName);
                if (!this.f.isAccessible()) {
                    this.f.setAccessible(true);
                }
            }
            catch (NoSuchFieldException ex) {
                throw new FatalBeanException("Could not resolve field", (Throwable)ex);
            }
        }

        public Object getObject() throws Exception {
            return this.f;
        }

        public Class getObjectType() {
            return class$java$lang$reflect$Field == null ? (class$java$lang$reflect$Field = ConfigBeanDefinitionParser.class$("java.lang.reflect.Field")) : class$java$lang$reflect$Field;
        }

        public boolean isSingleton() {
            return true;
        }
    }

    private class ParseContext {
        private int advisorOrderValue;

        private ParseContext() {
        }

        public int nextAdvisorOrderValue() {
            return this.advisorOrderValue++;
        }
    }
}

