/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.aop.MethodMatcher;
import org.springframework.util.Assert;

public abstract class MethodMatchers {
    public static MethodMatcher union(MethodMatcher a, MethodMatcher b) {
        return new UnionMethodMatcher(a, b);
    }

    public static MethodMatcher intersection(MethodMatcher a, MethodMatcher b) {
        return new IntersectionMethodMatcher(a, b);
    }

    private static class IntersectionMethodMatcher
    implements MethodMatcher,
    Serializable {
        private MethodMatcher a;
        private MethodMatcher b;

        private IntersectionMethodMatcher(MethodMatcher a, MethodMatcher b) {
            Assert.notNull((Object)a, (String)"First MethodMatcher must not be null");
            Assert.notNull((Object)b, (String)"Second MethodMatcher must not be null");
            this.a = a;
            this.b = b;
        }

        public boolean matches(Method method, Class targetClass) {
            return this.a.matches(method, targetClass) && this.b.matches(method, targetClass);
        }

        public boolean isRuntime() {
            return this.a.isRuntime() || this.b.isRuntime();
        }

        public boolean matches(Method method, Class targetClass, Object[] args) {
            boolean aMatches = this.a.isRuntime() ? this.a.matches(method, targetClass, args) : this.a.matches(method, targetClass);
            boolean bMatches = this.b.isRuntime() ? this.b.matches(method, targetClass, args) : this.b.matches(method, targetClass);
            return aMatches && bMatches;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IntersectionMethodMatcher)) {
                return false;
            }
            IntersectionMethodMatcher that = (IntersectionMethodMatcher)other;
            return this.a.equals(that.a) && this.b.equals(that.b);
        }

        public int hashCode() {
            int code = 17;
            code = 37 * code + this.a.hashCode();
            code = 37 * code + this.b.hashCode();
            return code;
        }
    }

    private static class UnionMethodMatcher
    implements MethodMatcher,
    Serializable {
        private MethodMatcher a;
        private MethodMatcher b;

        private UnionMethodMatcher(MethodMatcher a, MethodMatcher b) {
            Assert.notNull((Object)a, (String)"First MethodMatcher must not be null");
            Assert.notNull((Object)b, (String)"Second MethodMatcher must not be null");
            this.a = a;
            this.b = b;
        }

        public boolean matches(Method method, Class targetClass) {
            return this.a.matches(method, targetClass) || this.b.matches(method, targetClass);
        }

        public boolean isRuntime() {
            return this.a.isRuntime() || this.b.isRuntime();
        }

        public boolean matches(Method method, Class targetClass, Object[] args) {
            return this.a.matches(method, targetClass, args) || this.b.matches(method, targetClass, args);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UnionMethodMatcher)) {
                return false;
            }
            UnionMethodMatcher that = (UnionMethodMatcher)obj;
            return this.a.equals(that.a) && this.b.equals(that.b);
        }

        public int hashCode() {
            int code = 17;
            code = 37 * code + this.a.hashCode();
            code = 37 * code + this.b.hashCode();
            return code;
        }
    }
}

