/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.util.Arrays;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.Assert;

public abstract class AopProxyUtils {
    static /* synthetic */ Class class$org$springframework$aop$framework$Advised;

    public static Class getTargetClass(Object proxy) {
        if (AopUtils.isCglibProxy(proxy)) {
            return proxy.getClass().getSuperclass();
        }
        if (proxy instanceof Advised) {
            return ((Advised)proxy).getTargetSource().getTargetClass();
        }
        return proxy.getClass();
    }

    public static Class[] completeProxiedInterfaces(AdvisedSupport advised) {
        Class[] specifiedInterfaces;
        Class[] proxiedInterfaces = specifiedInterfaces = advised.getProxiedInterfaces();
        if (!advised.isOpaque() && !advised.isInterfaceProxied(class$org$springframework$aop$framework$Advised == null ? (class$org$springframework$aop$framework$Advised = AopProxyUtils.class$("org.springframework.aop.framework.Advised")) : class$org$springframework$aop$framework$Advised)) {
            proxiedInterfaces = new Class[specifiedInterfaces.length + 1];
            proxiedInterfaces[0] = class$org$springframework$aop$framework$Advised == null ? (class$org$springframework$aop$framework$Advised = AopProxyUtils.class$("org.springframework.aop.framework.Advised")) : class$org$springframework$aop$framework$Advised;
            System.arraycopy(specifiedInterfaces, 0, proxiedInterfaces, 1, specifiedInterfaces.length);
        }
        return proxiedInterfaces;
    }

    public static Class[] proxiedUserInterfaces(Object proxy) {
        Object[] proxyInterfaces = proxy.getClass().getInterfaces();
        if (proxy instanceof Advised) {
            Assert.isTrue((proxyInterfaces.length > 1 ? 1 : 0) != 0, (String)"JDK proxy must implement at least 1 interface aside from Advised");
            Class[] beanInterfaces = new Class[proxyInterfaces.length - 1];
            System.arraycopy(proxyInterfaces, 1, beanInterfaces, 0, beanInterfaces.length);
            return beanInterfaces;
        }
        Assert.notEmpty((Object[])proxyInterfaces, (String)"JDK proxy must implement at least 1 interface aside from Advised");
        return proxyInterfaces;
    }

    public static boolean equalsInProxy(AdvisedSupport a, AdvisedSupport b) {
        if (a == b) {
            return true;
        }
        if (!AopProxyUtils.equalsProxiedInterfaces(a, b)) {
            return false;
        }
        if (!AopProxyUtils.equalsAdvisors(a, b)) {
            return false;
        }
        if (a.getTargetSource() == null) {
            return b.getTargetSource() == null;
        }
        return a.getTargetSource().equals(b.getTargetSource());
    }

    public static boolean equalsProxiedInterfaces(AdvisedSupport a, AdvisedSupport b) {
        return Arrays.equals(a.getProxiedInterfaces(), b.getProxiedInterfaces());
    }

    public static boolean equalsAdvisors(AdvisedSupport a, AdvisedSupport b) {
        return Arrays.equals(a.getAdvisors(), b.getAdvisors());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

