/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.MemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.ast.Expr;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.bcel.BcelCflowAccessVar;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PatternNodeVisitor;
import org.aspectj.weaver.patterns.Pointcut;

public class ConcreteCflowPointcut
extends Pointcut {
    private Member cflowField;
    List slots;
    boolean usesCounter;
    private static final Member cflowStackIsValidMethod = MemberImpl.method(UnresolvedType.forName("org.aspectj.runtime.internal.CFlowStack"), 0, "isValid", "()Z");
    private static final Member cflowCounterIsValidMethod = MemberImpl.method(UnresolvedType.forName("org.aspectj.runtime.internal.CFlowCounter"), 0, "isValid", "()Z");

    public ConcreteCflowPointcut(Member cflowField, List slots, boolean usesCounter) {
        this.cflowField = cflowField;
        this.slots = slots;
        this.usesCounter = usesCounter;
        this.pointcutKind = (byte)10;
    }

    public Set couldMatchKinds() {
        return Shadow.ALL_SHADOW_KINDS;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return FuzzyBoolean.MAYBE;
    }

    protected FuzzyBoolean matchInternal(Shadow shadow) {
        return FuzzyBoolean.MAYBE;
    }

    public int[] getUsedFormalSlots() {
        if (this.slots == null) {
            return new int[0];
        }
        int[] indices = new int[this.slots.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = ((Slot)this.slots.get((int)i)).formalIndex;
        }
        return indices;
    }

    public void write(DataOutputStream s) throws IOException {
        throw new RuntimeException("unimplemented");
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        throw new RuntimeException("unimplemented");
    }

    public Pointcut parameterizeWith(Map typeVariableMap) {
        throw new RuntimeException("unimplemented");
    }

    public boolean equals(Object other) {
        if (!(other instanceof ConcreteCflowPointcut)) {
            return false;
        }
        ConcreteCflowPointcut o = (ConcreteCflowPointcut)other;
        return o.cflowField.equals(this.cflowField);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.cflowField.hashCode();
        return result;
    }

    public String toString() {
        return "concretecflow(" + this.cflowField + ")";
    }

    protected Test findResidueInternal(Shadow shadow, ExposedState state) {
        if (this.usesCounter) {
            return Test.makeFieldGetCall(this.cflowField, cflowCounterIsValidMethod, Expr.NONE);
        }
        if (this.slots != null) {
            Iterator i = this.slots.iterator();
            while (i.hasNext()) {
                Slot slot = (Slot)i.next();
                state.set(slot.formalIndex, new BcelCflowAccessVar(slot.formalType, this.cflowField, slot.arrayIndex));
            }
        }
        return Test.makeFieldGetCall(this.cflowField, cflowStackIsValidMethod, Expr.NONE);
    }

    public Pointcut concretize1(ResolvedType inAspect, ResolvedType declaringType, IntMap bindings) {
        throw new RuntimeException("unimplemented");
    }

    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public static class Slot {
        int formalIndex;
        ResolvedType formalType;
        int arrayIndex;

        public Slot(int formalIndex, ResolvedType formalType, int arrayIndex) {
            this.formalIndex = formalIndex;
            this.formalType = formalType;
            this.arrayIndex = arrayIndex;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Slot)) {
                return false;
            }
            Slot o = (Slot)other;
            return o.formalIndex == this.formalIndex && o.arrayIndex == this.arrayIndex && o.formalType.equals(this.formalType);
        }

        public String toString() {
            return "Slot(" + this.formalIndex + ", " + this.formalType + ", " + this.arrayIndex + ")";
        }
    }
}

