/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.reflect;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.TypeVariableReferenceType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.internal.tools.PointcutExpressionImpl;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.reflect.Java15AnnotationFinder;
import org.aspectj.weaver.reflect.Java15GenericSignatureInformationProvider;
import org.aspectj.weaver.reflect.JavaLangTypeToResolvedTypeConverter;
import org.aspectj.weaver.reflect.ReflectionBasedReferenceTypeDelegate;
import org.aspectj.weaver.reflect.ReflectionBasedResolvedMemberImpl;
import org.aspectj.weaver.tools.PointcutParameter;
import org.aspectj.weaver.tools.PointcutParser;

public class Java15ReflectionBasedReferenceTypeDelegate
extends ReflectionBasedReferenceTypeDelegate {
    private AjType<?> myType;
    private ResolvedType[] annotations;
    private ResolvedMember[] pointcuts;
    private ResolvedMember[] methods;
    private ResolvedMember[] fields;
    private TypeVariable[] typeVariables;
    private ResolvedType superclass;
    private ResolvedType[] superInterfaces;
    private String genericSignature = null;
    private JavaLangTypeToResolvedTypeConverter typeConverter;
    private Java15AnnotationFinder annotationFinder = null;

    public void initialize(ReferenceType aType, Class aClass, ClassLoader classLoader, World aWorld) {
        super.initialize(aType, aClass, classLoader, aWorld);
        this.myType = AjTypeSystem.getAjType(aClass);
        this.annotationFinder = new Java15AnnotationFinder();
        this.annotationFinder.setClassLoader(classLoader);
        this.typeConverter = new JavaLangTypeToResolvedTypeConverter(aWorld);
    }

    public ReferenceType buildGenericType() {
        return (ReferenceType)UnresolvedType.forGenericTypeVariables(this.getResolvedTypeX().getSignature(), this.getTypeVariables()).resolve(this.getWorld());
    }

    public AnnotationX[] getAnnotations() {
        return super.getAnnotations();
    }

    public ResolvedType[] getAnnotationTypes() {
        if (this.annotations == null) {
            this.annotations = this.annotationFinder.getAnnotations(this.getBaseClass(), this.getWorld());
        }
        return this.annotations;
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        ResolvedType[] myAnns = this.getAnnotationTypes();
        ResolvedType toLookFor = ofType.resolve(this.getWorld());
        for (int i = 0; i < myAnns.length; ++i) {
            if (myAnns[i] != toLookFor) continue;
            return true;
        }
        return false;
    }

    public ResolvedMember[] getDeclaredFields() {
        if (this.fields == null) {
            Field[] reflectFields = this.myType.getDeclaredFields();
            this.fields = new ResolvedMember[reflectFields.length];
            for (int i = 0; i < reflectFields.length; ++i) {
                this.fields[i] = this.createGenericFieldMember(reflectFields[i]);
            }
        }
        return this.fields;
    }

    public String getDeclaredGenericSignature() {
        if (this.genericSignature != null || this.isGeneric()) {
            // empty if block
        }
        return this.genericSignature;
    }

    public ResolvedType[] getDeclaredInterfaces() {
        if (this.superInterfaces == null) {
            Type[] genericInterfaces = this.getBaseClass().getGenericInterfaces();
            this.superInterfaces = this.typeConverter.fromTypes(genericInterfaces);
        }
        return this.superInterfaces;
    }

    public ResolvedType getSuperclass() {
        if (this.superclass == null && this.getBaseClass() != Object.class) {
            Type t = this.getBaseClass().getGenericSuperclass();
            if (t != null) {
                this.superclass = this.typeConverter.fromType(t);
            }
            if (t == null) {
                this.superclass = this.getWorld().resolve(UnresolvedType.OBJECT);
            }
        }
        return this.superclass;
    }

    public TypeVariable[] getTypeVariables() {
        TypeVariable[] workInProgressSetOfVariables = this.getResolvedTypeX().getWorld().getTypeVariablesCurrentlyBeingProcessed(this.getBaseClass());
        if (workInProgressSetOfVariables != null) {
            return workInProgressSetOfVariables;
        }
        if (this.typeVariables == null) {
            int i;
            java.lang.reflect.TypeVariable<Class<T>>[] tVars = this.getBaseClass().getTypeParameters();
            this.typeVariables = new TypeVariable[tVars.length];
            for (i = 0; i < tVars.length; ++i) {
                this.typeVariables[i] = new TypeVariable(tVars[i].getName());
            }
            this.getResolvedTypeX().getWorld().recordTypeVariablesCurrentlyBeingProcessed(this.getBaseClass(), this.typeVariables);
            for (i = 0; i < tVars.length; ++i) {
                TypeVariableReferenceType tvrt = (TypeVariableReferenceType)this.typeConverter.fromType(tVars[i]);
                TypeVariable tv = tvrt.getTypeVariable();
                this.typeVariables[i].setUpperBound(tv.getUpperBound());
                this.typeVariables[i].setAdditionalInterfaceBounds(tv.getAdditionalInterfaceBounds());
                this.typeVariables[i].setDeclaringElement(tv.getDeclaringElement());
                this.typeVariables[i].setDeclaringElementKind(tv.getDeclaringElementKind());
                this.typeVariables[i].setRank(tv.getRank());
                this.typeVariables[i].setLowerBound(tv.getLowerBound());
            }
            this.getResolvedTypeX().getWorld().forgetTypeVariablesCurrentlyBeingProcessed(this.getBaseClass());
        }
        return this.typeVariables;
    }

    public ResolvedMember[] getDeclaredMethods() {
        if (this.methods == null) {
            int i;
            Method[] reflectMethods = this.myType.getDeclaredMethods();
            Constructor[] reflectCons = this.myType.getDeclaredConstructors();
            this.methods = new ResolvedMember[reflectMethods.length + reflectCons.length];
            for (i = 0; i < reflectMethods.length; ++i) {
                this.methods[i] = this.createGenericMethodMember(reflectMethods[i]);
            }
            for (i = 0; i < reflectCons.length; ++i) {
                this.methods[i + reflectMethods.length] = this.createGenericConstructorMember(reflectCons[i]);
            }
        }
        return this.methods;
    }

    public ResolvedType getGenericResolvedType() {
        ReferenceType rt = this.getResolvedTypeX();
        if (rt.isParameterizedType() || rt.isRawType()) {
            return ((ResolvedType)rt).getGenericType();
        }
        return rt;
    }

    private ResolvedMember createGenericMethodMember(Method forMethod) {
        ReflectionBasedResolvedMemberImpl ret = new ReflectionBasedResolvedMemberImpl(Member.METHOD, (UnresolvedType)this.getGenericResolvedType(), forMethod.getModifiers(), (UnresolvedType)this.typeConverter.fromType(forMethod.getReturnType()), forMethod.getName(), (UnresolvedType[])this.typeConverter.fromTypes(forMethod.getParameterTypes()), (UnresolvedType[])this.typeConverter.fromTypes(forMethod.getExceptionTypes()), forMethod);
        ret.setAnnotationFinder(this.annotationFinder);
        ret.setGenericSignatureInformationProvider(new Java15GenericSignatureInformationProvider(this.getWorld()));
        return ret;
    }

    private ResolvedMember createGenericConstructorMember(Constructor forConstructor) {
        ReflectionBasedResolvedMemberImpl ret = new ReflectionBasedResolvedMemberImpl(Member.METHOD, (UnresolvedType)this.getGenericResolvedType(), forConstructor.getModifiers(), (UnresolvedType)ResolvedType.VOID, "<init>", (UnresolvedType[])this.typeConverter.fromTypes(forConstructor.getParameterTypes()), (UnresolvedType[])this.typeConverter.fromTypes(forConstructor.getExceptionTypes()), forConstructor);
        ret.setAnnotationFinder(this.annotationFinder);
        ret.setGenericSignatureInformationProvider(new Java15GenericSignatureInformationProvider(this.getWorld()));
        return ret;
    }

    private ResolvedMember createGenericFieldMember(Field forField) {
        ReflectionBasedResolvedMemberImpl ret = new ReflectionBasedResolvedMemberImpl(Member.FIELD, (UnresolvedType)this.getGenericResolvedType(), forField.getModifiers(), (UnresolvedType)this.typeConverter.fromType(forField.getType()), forField.getName(), new UnresolvedType[0], forField);
        ret.setAnnotationFinder(this.annotationFinder);
        ret.setGenericSignatureInformationProvider(new Java15GenericSignatureInformationProvider(this.getWorld()));
        return ret;
    }

    public ResolvedMember[] getDeclaredPointcuts() {
        if (this.pointcuts == null) {
            org.aspectj.lang.reflect.Pointcut[] pcs = this.myType.getDeclaredPointcuts();
            this.pointcuts = new ResolvedMember[pcs.length];
            PointcutParser parser = PointcutParser.getPointcutParserSupportingAllPrimitivesAndUsingSpecifiedClassloaderForResolution(this.classLoader);
            for (int i = 0; i < pcs.length; ++i) {
                AjType<?>[] ptypes = pcs[i].getParameterTypes();
                String[] pnames = pcs[i].getParameterNames();
                if (pnames.length != ptypes.length) {
                    throw new IllegalStateException("Required parameter names not available when parsing pointcut " + pcs[i].getName() + " in type " + this.getResolvedTypeX().getName());
                }
                PointcutParameter[] parameters = new PointcutParameter[ptypes.length];
                for (int j = 0; j < parameters.length; ++j) {
                    parameters[j] = parser.createPointcutParameter(pnames[j], ptypes[j].getJavaClass());
                }
                String pcExpr = pcs[i].getPointcutExpression().toString();
                PointcutExpressionImpl pEx = (PointcutExpressionImpl)parser.parsePointcutExpression(pcExpr, this.getBaseClass(), parameters);
                Pointcut pc = pEx.getUnderlyingPointcut();
                UnresolvedType[] weaverPTypes = new UnresolvedType[ptypes.length];
                for (int j = 0; j < weaverPTypes.length; ++j) {
                    weaverPTypes[j] = UnresolvedType.forName(ptypes[j].getName());
                }
                this.pointcuts[i] = new ResolvedPointcutDefinition(this.getResolvedTypeX(), pcs[i].getModifiers(), pcs[i].getName(), weaverPTypes, pc);
            }
        }
        return this.pointcuts;
    }

    public boolean isAnnotation() {
        return this.getBaseClass().isAnnotation();
    }

    public boolean isAnnotationStyleAspect() {
        return this.getBaseClass().isAnnotationPresent(Aspect.class);
    }

    public boolean isAnnotationWithRuntimeRetention() {
        if (!this.isAnnotation()) {
            return false;
        }
        if (this.getBaseClass().isAnnotationPresent(Retention.class)) {
            Retention retention = this.getBaseClass().getAnnotation(Retention.class);
            RetentionPolicy policy = retention.value();
            return policy == RetentionPolicy.RUNTIME;
        }
        return false;
    }

    public boolean isAspect() {
        return this.myType.isAspect();
    }

    public boolean isEnum() {
        return this.getBaseClass().isEnum();
    }

    public boolean isGeneric() {
        return this.getBaseClass().getTypeParameters().length > 0;
    }

    public boolean isAnonymous() {
        return this.myClass.isAnonymousClass();
    }
}

