/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.IOException;
import java.io.Writer;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.dbunit.dataset.stream.DataSetProducerAdapter;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.util.xml.XmlWriter;

public class XmlDataSetWriter
implements IDataSetConsumer {
    private static final String DATASET = "dataset";
    private static final String TABLE = "table";
    private static final String NAME = "name";
    private static final String COLUMN = "column";
    private static final String ROW = "row";
    private static final String VALUE = "value";
    private static final String NULL = "null";
    private static final String NONE = "none";
    static char[] CDATA_DETECTION_CHARS = new char[]{' ', '\n', '\r', '\t', '&', '<'};
    private XmlWriter _xmlWriter;
    private ITableMetaData _activeMetaData;

    public XmlDataSetWriter(Writer writer) {
        this._xmlWriter = new XmlWriter(writer);
        this._xmlWriter.enablePrettyPrint(true);
    }

    public XmlDataSetWriter(Writer writer, String encoding) {
        this._xmlWriter = new XmlWriter(writer, encoding);
        this._xmlWriter.enablePrettyPrint(true);
    }

    public void write(IDataSet dataSet) throws DataSetException {
        DataSetProducerAdapter provider = new DataSetProducerAdapter(dataSet);
        provider.setConsumer(this);
        provider.produce();
    }

    boolean needsCData(String text) {
        if (text == null) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            for (int j = 0; j < CDATA_DETECTION_CHARS.length; ++j) {
                if (CDATA_DETECTION_CHARS[j] != c) continue;
                return true;
            }
        }
        return false;
    }

    public void startDataSet() throws DataSetException {
        try {
            this._xmlWriter.writeDeclaration();
            this._xmlWriter.writeElement(DATASET);
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    public void endDataSet() throws DataSetException {
        try {
            this._xmlWriter.endElement();
            this._xmlWriter.close();
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    public void startTable(ITableMetaData metaData) throws DataSetException {
        try {
            this._activeMetaData = metaData;
            String tableName = this._activeMetaData.getTableName();
            this._xmlWriter.writeElement(TABLE);
            this._xmlWriter.writeAttribute(NAME, tableName);
            Column[] columns = this._activeMetaData.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                String columnName = columns[i].getColumnName();
                this._xmlWriter.writeElementWithText(COLUMN, columnName);
            }
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    public void endTable() throws DataSetException {
        try {
            this._xmlWriter.endElement();
            this._activeMetaData = null;
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    public void row(Object[] values) throws DataSetException {
        try {
            this._xmlWriter.writeElement(ROW);
            Column[] columns = this._activeMetaData.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                String columnName = columns[i].getColumnName();
                Object value = values[i];
                if (value == null) {
                    this._xmlWriter.writeEmptyElement(NULL);
                    continue;
                }
                if (value == ITable.NO_VALUE) {
                    this._xmlWriter.writeEmptyElement(NONE);
                    continue;
                }
                try {
                    String stringValue = DataType.asString(value);
                    this._xmlWriter.writeElement(VALUE);
                    if (this.needsCData(stringValue)) {
                        this._xmlWriter.writeCData(stringValue);
                    } else if (stringValue.length() > 0) {
                        this._xmlWriter.writeText(stringValue);
                    }
                    this._xmlWriter.endElement();
                    continue;
                }
                catch (TypeCastException e) {
                    throw new DataSetException("table=" + this._activeMetaData.getTableName() + ", row=" + i + ", column=" + columnName + ", value=" + value, e);
                }
            }
            this._xmlWriter.endElement();
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }
}

