/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.gen.jsr181;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.gen.GenerationContext;
import org.codehaus.xfire.gen.GenerationException;
import org.codehaus.xfire.gen.GeneratorPlugin;
import org.codehaus.xfire.gen.SchemaSupport;
import org.codehaus.xfire.gen.jsr181.AbstractPlugin;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceGenerator
extends AbstractPlugin
implements GeneratorPlugin {
    private static final Log log = LogFactory.getLog(AbstractServiceGenerator.class);

    @Override
    public void generate(GenerationContext context) throws Exception {
        if (!this.isWritten(context)) {
            // empty if block
        }
        Service service = context.getService();
        ServiceInfo serviceInfo = service.getServiceInfo();
        String clsName = this.getClassName(context, service);
        log.info((Object)("Creating class " + clsName));
        JDefinedClass jc = context.getCodeModel()._class(clsName, this.getClassType());
        SchemaSupport schema = context.getSchemaGenerator();
        this.annotate(context, service, jc);
        for (OperationInfo op : serviceInfo.getOperations()) {
            JType returnType = this.getReturnType(context, schema, op);
            JMethod method = jc.method(1, returnType, this.javify(op.getName()));
            boolean param = false;
            this.annotate(context, op, method);
            this.generateOperation(context, op, method);
        }
    }

    protected boolean isWritten(GenerationContext context) {
        return false;
    }

    private void generateOperation(GenerationContext context, OperationInfo op, JMethod method) throws GenerationException {
        Collection bindings = context.getService().getBindings();
        SchemaSupport schema = context.getSchemaGenerator();
        ArrayList<String> partNames = new ArrayList<String>();
        MessageInfo inputMsg = op.getInputMessage();
        for (MessagePartInfo part : inputMsg.getMessageParts()) {
            String varName = part.getName().getLocalPart();
            varName = this.getUniqueName(varName, partNames);
            partNames.add(varName);
            JType paramType = schema.getType(context, part.getName(), part.getSchemaType().getSchemaType());
            JVar jvar = method.param(0, paramType, varName);
            this.annotate(part, jvar);
        }
        for (Binding binding : bindings) {
            this.annotate(context, op, method, binding);
            List headers = binding.getHeaders(inputMsg).getMessageParts();
            for (MessagePartInfo part : headers) {
                String varName = part.getName().getLocalPart();
                varName = this.getUniqueName(varName, partNames);
                JType paramType = schema.getType(context, part.getName(), part.getSchemaType().getSchemaType());
                JVar jvar = method.param(0, paramType, varName);
                this.annotate(part, jvar, binding);
            }
        }
        if (op.hasOutput()) {
            MessageInfo outputMsg = op.getOutputMessage();
            Iterator rtitr = outputMsg.getMessageParts().iterator();
            MessagePartInfo returnPart = (MessagePartInfo)rtitr.next();
            this.annotateReturnType(method, returnPart);
            Iterator itr = bindings.iterator();
            while (itr.hasNext()) {
                this.annotateReturnType(method, returnPart, (Binding)itr.next());
            }
            while (rtitr.hasNext()) {
                MessagePartInfo part = (MessagePartInfo)rtitr.next();
                JType paramType = schema.getType(context, part.getName(), null);
                JVar jvar = method.param(0, paramType, part.getName().getLocalPart());
                this.annotateOutParam(part, jvar);
            }
            for (Binding binding : bindings) {
                List headers = binding.getHeaders(outputMsg).getMessageParts();
                for (MessagePartInfo part : headers) {
                    JType paramType = schema.getType(context, part.getName(), part.getSchemaType().getSchemaType());
                    JVar jvar = method.param(0, paramType, part.getName().getLocalPart());
                    this.annotateOutParam(part, jvar, binding);
                }
            }
        }
    }

    private String getUniqueName(String varName, List<String> partNames) {
        if (!partNames.contains(varName)) {
            return varName;
        }
        int i = 2;
        String v2;
        while (partNames.contains(v2 = varName + i)) {
            ++i;
        }
        return v2;
    }

    protected abstract String getClassName(GenerationContext var1, Service var2);

    protected abstract ClassType getClassType();

    protected void annotate(GenerationContext context, OperationInfo op, JMethod method) {
    }

    protected void annotate(GenerationContext context, OperationInfo op, JMethod method, Binding binding) {
    }

    protected void annotateOutParam(MessagePartInfo part, JVar jvar) {
    }

    protected void annotateOutParam(MessagePartInfo part, JVar jvar, Binding binding) {
    }

    protected void annotateReturnType(JMethod method, MessagePartInfo returnPart) {
    }

    protected void annotateReturnType(JMethod method, MessagePartInfo returnPart, Binding binding) {
    }

    protected void annotate(MessagePartInfo part, JVar jvar) {
    }

    protected void annotate(MessagePartInfo part, JVar jvar, Binding binding) {
    }

    protected JType getReturnType(GenerationContext context, SchemaSupport schema, OperationInfo op) throws GenerationException {
        JClass returnType;
        Iterator rtitr = op.getOutputMessage().getMessageParts().iterator();
        if (rtitr.hasNext()) {
            MessagePartInfo returnPart = (MessagePartInfo)rtitr.next();
            returnType = schema.getType(context, returnPart.getName(), returnPart.getSchemaType().getSchemaType());
        } else {
            returnType = context.getCodeModel().ref(Void.TYPE);
        }
        return returnType;
    }

    protected void annotate(GenerationContext context, Service service, JDefinedClass jc) {
    }

    protected void annotate(GenerationContext context, Service service, JDefinedClass jc, Binding binding) {
    }
}

