/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.binding;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.fault.FaultSender;
import org.codehaus.xfire.fault.SoapFaultSerializer;
import org.codehaus.xfire.handler.CustomFaultHandler;
import org.codehaus.xfire.handler.OutMessageSender;
import org.codehaus.xfire.service.FaultInfo;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartContainer;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.ServiceInfo;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ObjectInvoker;
import org.codehaus.xfire.service.binding.ServiceInvocationHandler;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.SoapBinding;
import org.codehaus.xfire.soap.SoapTransport;
import org.codehaus.xfire.soap.SoapVersion;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.xfire.util.MethodComparator;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.xfire.util.ServiceUtils;
import org.codehaus.xfire.wsdl11.builder.DefaultWSDLBuilderFactory;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilderAdapter;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilderFactory;

public class ObjectServiceFactory
implements ServiceFactory {
    public static final String PORT_TYPE = "objectServiceFactory.portType";
    public static final String STYLE = "sobjectServiceFactory.tyle";
    public static final String USE = "objectServiceFactory.use";
    public static final String SOAP_VERSION = "objectServiceFactory.soapVersion";
    private BindingProvider bindingProvider;
    private TransportManager transportManager;
    private String style;
    private String use;
    private Set ignoredClasses = new HashSet();
    private SoapVersion soapVersion = Soap11.getInstance();
    private boolean voidOneWay;
    private WSDLBuilderFactory wsdlBuilderFactory = new DefaultWSDLBuilderFactory();
    private boolean customFaultsEnabled = true;
    private boolean bindingCreationEnabled = true;
    static /* synthetic */ Class class$org$codehaus$xfire$MessageContext;
    static /* synthetic */ Class class$org$codehaus$xfire$fault$XFireFault;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$Throwable;

    public ObjectServiceFactory() {
        this.setStyle("wrapped");
        this.setUse("literal");
        this.ignoredClasses.add("java.lang.Object");
        this.ignoredClasses.add("java.lang.Throwable");
        this.ignoredClasses.add("org.omg.CORBA_2_3.portable.ObjectImpl");
        this.ignoredClasses.add("org.omg.CORBA.portable.ObjectImpl");
        this.ignoredClasses.add("javax.ejb.EJBObject");
        this.ignoredClasses.add("javax.rmi.CORBA.Stub");
    }

    public ObjectServiceFactory(TransportManager transportManager, BindingProvider provider) {
        this();
        this.bindingProvider = provider;
        this.transportManager = transportManager;
    }

    public ObjectServiceFactory(TransportManager transportManager) {
        this(transportManager, null);
    }

    public ObjectServiceFactory(BindingProvider bp) {
        this(null, bp);
    }

    public BindingProvider getBindingProvider() {
        if (this.bindingProvider == null) {
            try {
                this.bindingProvider = (BindingProvider)ClassLoaderUtils.loadClass("org.codehaus.xfire.aegis.AegisBindingProvider", this.getClass()).newInstance();
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Couldn't find a binding provider!", e);
            }
        }
        return this.bindingProvider;
    }

    public Service create(Class clazz, URL wsdlUrl) throws Exception {
        throw new UnsupportedOperationException("create() isn't working yet.");
    }

    public Service create(Class clazz) {
        return this.create(clazz, (Map)null);
    }

    public Service create(Class clazz, Map properties) {
        return this.create(clazz, null, null, properties);
    }

    protected String makeServiceNameFromClassName(Class clazz) {
        return ServiceUtils.makeServiceNameFromClassName(clazz);
    }

    public Service create(Class clazz, String name, String namespace, Map properties) {
        String theName = name != null ? name : this.makeServiceNameFromClassName(clazz);
        String theNamespace = namespace != null ? namespace : NamespaceHelper.makeNamespaceFromClassName(clazz.getName(), "http");
        QName qName = new QName(theNamespace, theName);
        SoapVersion theVersion = null;
        String theStyle = null;
        String theUse = null;
        QName portType = null;
        if (properties != null) {
            theVersion = (SoapVersion)properties.get(SOAP_VERSION);
            theStyle = (String)properties.get(STYLE);
            theUse = (String)properties.get(USE);
            portType = (QName)properties.get(PORT_TYPE);
        }
        if (theVersion == null) {
            theVersion = this.soapVersion;
        }
        if (theStyle == null) {
            theStyle = this.style;
        }
        if (theUse == null) {
            theUse = this.use;
        }
        if (portType == null) {
            portType = new QName(theNamespace, theName + "PortType");
        }
        ServiceInfo serviceInfo = new ServiceInfo(portType, clazz);
        if (theStyle.equals("wrapped")) {
            serviceInfo.setWrapped(true);
        }
        Service endpoint = new Service(serviceInfo);
        endpoint.setName(qName);
        this.setProperties(endpoint, properties);
        endpoint.setSoapVersion(theVersion);
        endpoint.setInvoker(new ObjectInvoker());
        endpoint.setFaultSerializer(new SoapFaultSerializer());
        endpoint.setWSDLWriter(new WSDLBuilderAdapter(this.getWsdlBuilderFactory(), endpoint));
        this.initializeOperations(endpoint, theStyle);
        endpoint.setProperty(STYLE, theStyle);
        endpoint.setProperty(USE, theUse);
        if (this.bindingCreationEnabled) {
            this.createBindings(endpoint);
        }
        try {
            BindingProvider provider = this.getBindingProvider();
            provider.initialize(endpoint);
            endpoint.setBindingProvider(provider);
        }
        catch (Exception e) {
            if (e instanceof XFireRuntimeException) {
                throw (XFireRuntimeException)e;
            }
            throw new XFireRuntimeException("Couldn't load provider.", e);
        }
        this.registerHandlers(endpoint);
        return endpoint;
    }

    protected void createBindings(Service service) {
        QName name = service.getName();
        if (this.transportManager == null) {
            QName bindingName = new QName(name.getNamespaceURI(), name.getLocalPart() + "SoapBinding");
            this.createSoapBinding(service, name);
            return;
        }
        Iterator itr = this.transportManager.getTransports().iterator();
        while (itr.hasNext()) {
            Transport t = (Transport)itr.next();
            if (!(t instanceof SoapTransport)) continue;
            SoapTransport st = (SoapTransport)t;
            QName bindingName = new QName(name.getNamespaceURI(), name.getLocalPart() + st.getName() + "Binding");
            this.createSoapBinding(service, bindingName, st);
        }
    }

    public SoapBinding createSoapBinding(Service service, QName name, SoapTransport transport) {
        SoapBinding binding = this.createSoapBinding(service, name);
        binding.setTransport(transport);
        return binding;
    }

    public SoapBinding createSoapBinding(Service service, QName name) {
        ServiceInfo serviceInfo = service.getServiceInfo();
        SoapBinding binding = new SoapBinding(name, service);
        String style = (String)service.getProperty(STYLE);
        String use = (String)service.getProperty(USE);
        binding.setStyle(style);
        binding.setUse(use);
        binding.setSerializer(SoapBinding.getSerializer(style, use));
        Iterator itr = serviceInfo.getOperations().iterator();
        while (itr.hasNext()) {
            OperationInfo op = (OperationInfo)itr.next();
            this.createBindingOperation(service, binding, op);
        }
        service.addBinding(binding);
        return binding;
    }

    protected void createBindingOperation(Service service, SoapBinding binding, OperationInfo op) {
        binding.setSoapAction(op, this.getAction(op));
        this.createMessageBinding(binding, op.getInputMessage());
        if (op.hasOutput()) {
            this.createMessageBinding(binding, op.getOutputMessage());
        }
        Iterator fitr = op.getFaults().iterator();
        while (fitr.hasNext()) {
            FaultInfo fault = (FaultInfo)fitr.next();
        }
    }

    private void createMessageBinding(SoapBinding binding, MessageInfo msg) {
        Method method = msg.getOperation().getMethod();
        Class<?>[] paramClasses = method.getParameterTypes();
        boolean isDoc = binding.getStyle().equals("document");
        MessagePartContainer parts = binding.getHeaders(msg);
        for (int j = 0; j < paramClasses.length; ++j) {
            if (paramClasses[j].equals(class$org$codehaus$xfire$MessageContext == null ? ObjectServiceFactory.class$("org.codehaus.xfire.MessageContext") : class$org$codehaus$xfire$MessageContext) || !this.isHeader(method, j)) continue;
            QName q = this.getInParameterName(binding.getService(), msg.getOperation(), method, j, isDoc);
            parts.addMessagePart(q, paramClasses[j]).setIndex(j);
        }
    }

    protected void registerHandlers(Service service) {
        service.addInHandler(new ServiceInvocationHandler());
        service.addOutHandler(new OutMessageSender());
        service.addFaultHandler(new FaultSender());
        service.addFaultHandler(new CustomFaultHandler());
    }

    private void setProperties(Service service, Map properties) {
        if (properties == null) {
            return;
        }
        Iterator itr = properties.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            service.setProperty((String)entry.getKey(), entry.getValue());
        }
    }

    protected void initializeOperations(Service endpoint, String style) {
        Method[] methods = endpoint.getServiceInfo().getServiceClass().getMethods();
        Arrays.sort(methods, new MethodComparator());
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!this.isValidMethod(method)) continue;
            this.addOperation(endpoint, method, style);
        }
    }

    public void addIgnoredMethods(String className) {
        this.ignoredClasses.add(className);
    }

    protected boolean isValidMethod(Method method) {
        if (this.ignoredClasses.contains(method.getDeclaringClass().getName())) {
            return false;
        }
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers);
    }

    protected OperationInfo addOperation(Service endpoint, Method method, String style) {
        ServiceInfo service = endpoint.getServiceInfo();
        String opName = this.getOperationName(service, method);
        OperationInfo op = service.addOperation(opName, method);
        Class<?>[] paramClasses = method.getParameterTypes();
        boolean isDoc = style.equals("document");
        MessageInfo inMsg = op.createMessage(this.createInputMessageName(op));
        op.setInputMessage(inMsg);
        for (int j = 0; j < paramClasses.length; ++j) {
            if (paramClasses[j].equals(class$org$codehaus$xfire$MessageContext == null ? ObjectServiceFactory.class$("org.codehaus.xfire.MessageContext") : class$org$codehaus$xfire$MessageContext) || this.isHeader(method, j)) continue;
            QName q = this.getInParameterName(endpoint, op, method, j, isDoc);
            inMsg.addMessagePart(q, paramClasses[j]).setIndex(j);
        }
        String mep = this.getMEP(method);
        op.setMEP(mep);
        if (this.hasOutMessage(mep)) {
            MessageInfo outMsg = op.createMessage(this.createOutputMessageName(op));
            op.setOutputMessage(outMsg);
            Class<Void> returnType = method.getReturnType();
            if (!returnType.isAssignableFrom(Void.TYPE) && !this.isHeader(method, -1)) {
                QName q = this.getOutParameterName(endpoint, op, method, isDoc);
                outMsg.addMessagePart(q, method.getReturnType()).setIndex(-1);
            }
        }
        if (this.isCustomFaultsEnabled()) {
            this.initializeFaults(method, service, op);
        }
        op.setAsync(this.isAsync(method));
        return op;
    }

    protected QName createInputMessageName(OperationInfo op) {
        return new QName(op.getService().getPortType().getNamespaceURI(), op.getName() + "Request");
    }

    protected QName createOutputMessageName(OperationInfo op) {
        return new QName(op.getService().getPortType().getNamespaceURI(), op.getName() + "Response");
    }

    protected boolean hasOutMessage(String mep) {
        return !mep.equals("urn:xfire:mep:in");
    }

    protected void initializeFaults(Method method, ServiceInfo service, OperationInfo op) {
        Class<?>[] exceptionClasses = method.getExceptionTypes();
        for (int i = 0; i < exceptionClasses.length; ++i) {
            Class<?> exClazz = exceptionClasses[i];
            if (exClazz.equals(class$org$codehaus$xfire$fault$XFireFault == null ? ObjectServiceFactory.class$("org.codehaus.xfire.fault.XFireFault") : class$org$codehaus$xfire$fault$XFireFault) || exClazz.equals(class$java$lang$Exception == null ? ObjectServiceFactory.class$("java.lang.Exception") : class$java$lang$Exception) || exClazz.equals(class$java$lang$RuntimeException == null ? ObjectServiceFactory.class$("java.lang.RuntimeException") : class$java$lang$RuntimeException) || exClazz.equals(class$java$lang$Throwable == null ? ObjectServiceFactory.class$("java.lang.Throwable") : class$java$lang$Throwable)) continue;
            String name = ServiceUtils.makeServiceNameFromClassName(exClazz);
            FaultInfo info = op.addFault(name);
            info.addMessagePart(new QName(service.getPortType().getNamespaceURI(), name), exClazz);
        }
    }

    protected String getAction(OperationInfo op) {
        return "";
    }

    protected boolean isHeader(Method method, int j) {
        return false;
    }

    protected String getOperationName(ServiceInfo service, Method method) {
        if (service.getOperation(method.getName()) == null) {
            return method.getName();
        }
        int i = 1;
        String name;
        while (service.getOperation(name = method.getName() + i) != null) {
            ++i;
        }
        return name;
    }

    protected String getMEP(Method method) {
        if (this.isVoidOneWay() && method.getReturnType().equals(Void.TYPE)) {
            return "urn:xfire:mep:in";
        }
        return "urn:xfire:mep:in-out";
    }

    protected boolean isAsync(Method method) {
        return false;
    }

    protected QName getInParameterName(Service endpoint, OperationInfo op, Method method, int paramNumber, boolean doc) {
        QName suggestion = this.getBindingProvider().getSuggestedName(endpoint, op, paramNumber);
        if (suggestion != null) {
            return suggestion;
        }
        String paramName = "";
        if (doc) {
            paramName = method.getName();
        }
        return new QName(endpoint.getServiceInfo().getPortType().getNamespaceURI(), paramName + "in" + paramNumber);
    }

    protected QName getOutParameterName(Service endpoint, OperationInfo op, Method method, boolean doc) {
        QName suggestion = this.getBindingProvider().getSuggestedName(endpoint, op, -1);
        if (suggestion != null) {
            return suggestion;
        }
        String outName = "";
        if (doc) {
            outName = method.getName();
        }
        return new QName(endpoint.getServiceInfo().getPortType().getNamespaceURI(), outName + "out");
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    public void setTransportManager(TransportManager transportManager) {
        this.transportManager = transportManager;
    }

    public void setBindingProvider(BindingProvider bindingProvider) {
        this.bindingProvider = bindingProvider;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public SoapVersion getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(SoapVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    public boolean isVoidOneWay() {
        return this.voidOneWay;
    }

    public void setVoidOneWay(boolean voidOneWay) {
        this.voidOneWay = voidOneWay;
    }

    public WSDLBuilderFactory getWsdlBuilderFactory() {
        return this.wsdlBuilderFactory;
    }

    public void setWsdlBuilderFactory(WSDLBuilderFactory wsdlBuilderFactory) {
        this.wsdlBuilderFactory = wsdlBuilderFactory;
    }

    public boolean isCustomFaultsEnabled() {
        return this.customFaultsEnabled;
    }

    public void setCustomFaultsEnabled(boolean customFaultsEnabled) {
        this.customFaultsEnabled = customFaultsEnabled;
    }

    public boolean isBindingCreationEnabled() {
        return this.bindingCreationEnabled;
    }

    public void setBindingCreationEnabled(boolean bindingCreationEnabled) {
        this.bindingCreationEnabled = bindingCreationEnabled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

