/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageExchange;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.xfire.util.stax.DepthXMLStreamReader;

public abstract class AbstractBinding
implements MessageSerializer {
    private static final QName XSD_ANY = new QName("http://www.w3.org/2001/XMLSchema", "anyType", "xsd");
    public static final String RESPONSE_VALUE = "xfire.java.response";
    public static final String RESPONSE_PIPE = "xfire.java.responsePipe";
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;

    public void setOperation(OperationInfo operation, MessageContext context) {
        MessageExchange exchange = context.createMessageExchange(operation);
        context.setExchange(exchange);
    }

    protected void nextEvent(XMLStreamReader dr) {
        try {
            dr.next();
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Couldn't parse stream.", e);
        }
    }

    protected OperationInfo findOperation(Collection operations, List parameters) {
        Iterator itr = operations.iterator();
        while (itr.hasNext()) {
            OperationInfo o = (OperationInfo)itr.next();
            List messageParts = o.getInputMessage().getMessageParts();
            if (messageParts.size() != parameters.size() || !this.checkParameters(messageParts, parameters)) continue;
            return o;
        }
        return null;
    }

    private boolean checkParameters(List messageParts, List parameters) {
        Iterator messagePartIterator = messageParts.iterator();
        Iterator parameterIterator = parameters.iterator();
        while (parameterIterator.hasNext()) {
            Object param = parameterIterator.next();
            MessagePartInfo mpi = (MessagePartInfo)messagePartIterator.next();
            if (mpi.getTypeClass().isAssignableFrom(param.getClass())) continue;
            if (!param.getClass().isPrimitive() && mpi.getTypeClass().isPrimitive()) {
                return this.checkPrimitiveMatch(mpi.getTypeClass(), param.getClass());
            }
            return false;
        }
        return true;
    }

    private boolean checkPrimitiveMatch(Class clazz, Class typeClass) {
        return typeClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractBinding.class$("java.lang.Integer")) : class$java$lang$Integer) && clazz == Integer.TYPE || typeClass == (class$java$lang$Double == null ? (class$java$lang$Double = AbstractBinding.class$("java.lang.Double")) : class$java$lang$Double) && clazz == Double.TYPE || typeClass == (class$java$lang$Long == null ? (class$java$lang$Long = AbstractBinding.class$("java.lang.Long")) : class$java$lang$Long) && clazz == Long.TYPE || typeClass == (class$java$lang$Float == null ? (class$java$lang$Float = AbstractBinding.class$("java.lang.Float")) : class$java$lang$Float) && clazz == Float.TYPE || typeClass == (class$java$lang$Short == null ? (class$java$lang$Short = AbstractBinding.class$("java.lang.Short")) : class$java$lang$Short) && clazz == Short.TYPE || typeClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractBinding.class$("java.lang.Boolean")) : class$java$lang$Boolean) && clazz == Boolean.TYPE || typeClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = AbstractBinding.class$("java.lang.Byte")) : class$java$lang$Byte) && clazz == Byte.TYPE;
    }

    protected MessagePartInfo findMessagePart(MessageContext context, Collection operations, QName name, int index) {
        MessagePartInfo lastChoice = null;
        Iterator itr = operations.iterator();
        while (itr.hasNext()) {
            OperationInfo op = (OperationInfo)itr.next();
            MessageInfo msgInfo = null;
            msgInfo = this.isClientModeOn(context) ? op.getOutputMessage() : op.getInputMessage();
            List bodyParts = msgInfo.getMessageParts();
            if (bodyParts.size() == 0 || bodyParts.size() <= index) continue;
            MessagePartInfo p = (MessagePartInfo)msgInfo.getMessageParts().get(index);
            if (p.getName().equals(name)) {
                return p;
            }
            if (!p.getSchemaType().getSchemaType().equals(XSD_ANY)) continue;
            lastChoice = p;
        }
        return lastChoice;
    }

    protected void read(InMessage inMessage, MessageContext context, Collection operations) throws XFireFault {
        ArrayList<Object> parameters = new ArrayList<Object>();
        OperationInfo opInfo = context.getExchange().getOperation();
        Binding binding = context.getBinding();
        DepthXMLStreamReader dr = new DepthXMLStreamReader(context.getInMessage().getXMLStreamReader());
        int param = 0;
        while (STAXUtils.toNextElement(dr)) {
            MessagePartInfo p = opInfo != null && this.isClientModeOn(context) ? (MessagePartInfo)opInfo.getOutputMessage().getMessageParts().get(param) : (opInfo != null && !this.isClientModeOn(context) ? (MessagePartInfo)opInfo.getInputMessage().getMessageParts().get(param) : this.findMessagePart(context, operations, dr.getName(), param));
            if (p == null) {
                throw new XFireFault("Parameter " + dr.getName() + " does not exist!", "Sender");
            }
            ++param;
            parameters.add(context.getService().getBindingProvider().readParameter(p, dr, context));
        }
        if (opInfo == null && !this.isClientModeOn(context)) {
            opInfo = this.findOperation(operations, parameters);
            if (opInfo == null) {
                StringBuffer sb = new StringBuffer("Could not find appropriate operation for request ");
                sb.append(((OperationInfo)operations.iterator().next()).getName());
                sb.append('(');
                Iterator iterator = parameters.iterator();
                while (iterator.hasNext()) {
                    sb.append(iterator.next().getClass().getName());
                    if (!iterator.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(") in service '");
                sb.append(context.getService().getSimpleName());
                sb.append('\'');
                throw new XFireFault(sb.toString(), "Sender");
            }
            this.setOperation(opInfo, context);
        }
        context.getInMessage().setBody(parameters);
    }

    public boolean isClientModeOn(MessageContext context) {
        Boolean on = (Boolean)context.getProperty("client.mode");
        return on != null && on != false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

