/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.service.event.RegistrationEvent;
import org.codehaus.xfire.service.event.RegistrationEventListener;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.transport.dead.DeadLetterTransport;
import org.codehaus.xfire.transport.http.HttpTransport;
import org.codehaus.xfire.transport.http.SoapHttpTransport;
import org.codehaus.xfire.transport.local.LocalTransport;

public class DefaultTransportManager
implements TransportManager,
RegistrationEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$codehaus$xfire$transport$DefaultTransportManager == null ? (class$org$codehaus$xfire$transport$DefaultTransportManager = DefaultTransportManager.class$("org.codehaus.xfire.transport.DefaultTransportManager")) : class$org$codehaus$xfire$transport$DefaultTransportManager));
    private Map services = new HashMap();
    private Set transports = new LinkedHashSet();
    private Map binding2Transport = new HashMap();
    private ServiceRegistry serviceRegistry;
    static /* synthetic */ Class class$org$codehaus$xfire$transport$DefaultTransportManager;

    public DefaultTransportManager() {
    }

    public DefaultTransportManager(ServiceRegistry registry) {
        this.serviceRegistry = registry;
        this.initialize();
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void initialize() {
        this.initializeTransports();
        this.register(new LocalTransport());
        this.register(new DeadLetterTransport());
        this.register(new SoapHttpTransport());
        this.register(new HttpTransport());
    }

    protected void initializeTransports() {
        Iterator itr = this.serviceRegistry.getServices().iterator();
        while (itr.hasNext()) {
            Service endpoint = (Service)itr.next();
            this.enableAll(endpoint);
        }
        this.serviceRegistry.addRegistrationEventListener(this);
    }

    public void register(Transport transport) {
        this.transports.add(transport);
        String[] bindingIds = transport.getSupportedBindings();
        for (int i = 0; i < bindingIds.length; ++i) {
            this.binding2Transport.put(bindingIds[i], transport);
        }
        Iterator itr = this.services.values().iterator();
        while (itr.hasNext()) {
            Set serviceTransports = (Set)itr.next();
            serviceTransports.add(transport);
        }
        log.debug((Object)("Registered transport " + transport));
    }

    public void unregister(Transport transport) {
        this.transports.remove(transport);
        Iterator itr = this.services.values().iterator();
        while (itr.hasNext()) {
            Set serviceTransports = (Set)itr.next();
            if (serviceTransports == null) continue;
            serviceTransports.remove(transport);
        }
    }

    public void enable(Transport transport, Service service) {
        HashSet<Transport> serviceTransports = (HashSet<Transport>)this.services.get(service);
        if (serviceTransports == null) {
            serviceTransports = new HashSet<Transport>();
            this.services.put(service, serviceTransports);
        }
        serviceTransports.add(transport);
    }

    public void disable(Transport transport, Service service) {
        Set serviceTransports = (Set)this.services.get(service);
        if (serviceTransports == null) {
            return;
        }
        serviceTransports.remove(transport);
    }

    public Collection getTransports(Service service) {
        HashSet transports = (HashSet)this.services.get(service);
        if (transports != null) {
            return transports;
        }
        return null;
    }

    public Collection getTransports() {
        return this.transports;
    }

    public void enableAll(Service service) {
        HashSet<Transport> serviceTransports = (HashSet<Transport>)this.services.get(service);
        if (serviceTransports == null) {
            serviceTransports = new HashSet<Transport>();
            this.services.put(service, serviceTransports);
        }
        Iterator itr = this.transports.iterator();
        while (itr.hasNext()) {
            Transport t = (Transport)itr.next();
            serviceTransports.add(t);
        }
    }

    public void disableAll(Service service) {
        HashSet serviceTransports = (HashSet)this.services.get(service);
        if (serviceTransports == null) {
            return;
        }
        Iterator itr = this.transports.iterator();
        while (itr.hasNext()) {
            Transport t = (Transport)itr.next();
            serviceTransports.remove(t);
        }
    }

    public boolean isEnabled(Transport transport, Service service) {
        HashSet serviceTransports = (HashSet)this.services.get(service);
        if (serviceTransports == null) {
            return false;
        }
        return serviceTransports.contains(transport);
    }

    public void endpointRegistered(RegistrationEvent event) {
        this.enableAll(event.getEndpoint());
    }

    public void endpointUnregistered(RegistrationEvent event) {
        this.disableAll(event.getEndpoint());
    }

    public Transport getTransportForUri(String uri) {
        Iterator itr = this.transports.iterator();
        while (itr.hasNext()) {
            Transport t = (Transport)itr.next();
            if (!t.isUriSupported(uri)) continue;
            return t;
        }
        return null;
    }

    public Collection getTransportsForUri(String uri) {
        HashSet<Transport> uritrans = new HashSet<Transport>();
        Iterator itr = this.transports.iterator();
        while (itr.hasNext()) {
            Transport t = (Transport)itr.next();
            if (!t.isUriSupported(uri)) continue;
            uritrans.add(t);
        }
        return uritrans;
    }

    public Transport getTransport(String id) {
        return (Transport)this.binding2Transport.get(id);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

