/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.soap.SoapVersion;
import org.codehaus.xfire.transport.AbstractTransport;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.DefaultEndpoint;
import org.codehaus.xfire.transport.http.HttpChannel;
import org.codehaus.xfire.transport.http.XFireServletController;

public class HttpTransport
extends AbstractTransport {
    private static final Log log = LogFactory.getLog((Class)(class$org$codehaus$xfire$transport$http$HttpTransport == null ? (class$org$codehaus$xfire$transport$http$HttpTransport = HttpTransport.class$("org.codehaus.xfire.transport.http.HttpTransport")) : class$org$codehaus$xfire$transport$http$HttpTransport));
    public static final String HTTP_BINDING = "http://www.w3.org/2004/08/wsdl/http";
    public static final String CHUNKING_ENABLED = "urn:xfire:transport:http:chunking-enabled";
    public static final String HTTP_TRANSPORT_NS = "http://schemas.xmlsoap.org/soap/http";
    private static final String URI_PREFIX = "urn:xfire:transport:http:";
    private static final MimeTypeHandler mimeHandler = new MimeTypeHandler();
    static /* synthetic */ Class class$org$codehaus$xfire$transport$http$HttpTransport;

    public HttpTransport() {
        this.addFaultHandler(new FaultResponseCodeHandler());
        this.addFaultHandler(mimeHandler);
        this.addOutHandler(mimeHandler);
    }

    protected Channel createNewChannel(String uri) {
        log.debug((Object)("Creating new channel for uri: " + uri));
        HttpChannel c = new HttpChannel(uri, this);
        c.setEndpoint(new DefaultEndpoint());
        return c;
    }

    protected String getUriPrefix() {
        return URI_PREFIX;
    }

    public String getServiceURL(Service service) {
        HttpServletRequest req = XFireServletController.getRequest();
        if (req == null) {
            return "http://localhost/services/" + service.getSimpleName();
        }
        StringBuffer output = new StringBuffer(128);
        output.append(req.getScheme());
        output.append("://");
        output.append(req.getServerName());
        if (req.getServerPort() != 80 && req.getServerPort() != 443 && req.getServerPort() != 0) {
            output.append(':');
            output.append(req.getServerPort());
        }
        output.append(req.getRequestURI());
        return output.toString();
    }

    public String getTransportURI(Service service) {
        return HTTP_TRANSPORT_NS;
    }

    protected String getWebappBase(HttpServletRequest request) {
        StringBuffer baseURL = new StringBuffer(128);
        baseURL.append(request.getScheme());
        baseURL.append("://");
        baseURL.append(request.getServerName());
        if (request.getServerPort() != 80) {
            baseURL.append(":");
            baseURL.append(request.getServerPort());
        }
        baseURL.append(request.getContextPath());
        return baseURL.toString();
    }

    public String[] getSupportedBindings() {
        return new String[]{HTTP_BINDING};
    }

    public String[] getKnownUriSchemes() {
        return new String[]{"http://", "https://"};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MimeTypeHandler
    extends AbstractHandler {
        public String getPhase() {
            return "transport";
        }

        public void invoke(MessageContext context) {
            HttpServletResponse response = XFireServletController.getResponse();
            if (response != null) {
                AbstractMessage msg = context.getOutMessage();
                if (msg == null) {
                    msg = context.getExchange().getFaultMessage();
                }
                if (msg == null) {
                    return;
                }
                SoapVersion soap = msg.getSoapVersion();
                String encoding = msg.getEncoding();
                if (encoding == null || encoding.length() == 0) {
                    encoding = "UTF-8";
                }
                if (soap instanceof Soap11) {
                    response.setContentType("text/xml; charset=" + encoding);
                } else if (soap instanceof Soap12) {
                    response.setContentType("application/soap+xml; charset=" + encoding);
                }
            }
        }
    }

    public static class FaultResponseCodeHandler
    extends AbstractHandler {
        public String getPhase() {
            return "transport";
        }

        public void invoke(MessageContext context) {
            HttpServletResponse response = XFireServletController.getResponse();
            if (response != null) {
                response.setStatus(500);
            }
        }
    }
}

