/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jdom.Element;
import org.jdom.Namespace;

public class NamespaceHelper {
    public static String getUniquePrefix(Element element, String namespaceURI) {
        String prefix = NamespaceHelper.getPrefix(element, namespaceURI);
        if (prefix == null) {
            prefix = NamespaceHelper.getUniquePrefix(element);
            element.addNamespaceDeclaration(Namespace.getNamespace((String)prefix, (String)namespaceURI));
        }
        return prefix;
    }

    public static String getPrefix(Element element, String namespaceURI) {
        if (element.getNamespaceURI().equals(namespaceURI)) {
            return element.getNamespacePrefix();
        }
        List namespaces = element.getAdditionalNamespaces();
        Iterator itr = namespaces.iterator();
        while (itr.hasNext()) {
            Namespace ns = (Namespace)itr.next();
            if (!ns.getURI().equals(namespaceURI)) continue;
            return ns.getPrefix();
        }
        if (element.getParentElement() != null) {
            return NamespaceHelper.getPrefix(element.getParentElement(), namespaceURI);
        }
        return null;
    }

    private static String getUniquePrefix(Element el) {
        int n = 1;
        String nsPrefix;
        while (el.getNamespace(nsPrefix = "ns" + n) != null) {
            ++n;
        }
        return nsPrefix;
    }

    public static String getUniquePrefix(XMLStreamWriter writer, String namespaceURI, boolean declare) throws XMLStreamException {
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = NamespaceHelper.getUniquePrefix(writer);
            if (declare) {
                writer.writeNamespace(prefix, namespaceURI);
            }
        }
        return prefix;
    }

    public static String getUniquePrefix(XMLStreamWriter writer) {
        int n = 1;
        while (true) {
            String nsPrefix = "ns" + n;
            if (writer.getNamespaceContext().getNamespaceURI(nsPrefix) == null) {
                return nsPrefix;
            }
            ++n;
        }
    }

    public static String makeNamespaceFromClassName(String className, String protocol) {
        int index = className.lastIndexOf(".");
        if (index == -1) {
            return protocol + "://" + "DefaultNamespace";
        }
        String packageName = className.substring(0, index);
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken();
        }
        StringBuffer sb = new StringBuffer(80);
        for (int i = words.length - 1; i >= 0; --i) {
            String word = words[i];
            if (i != words.length - 1) {
                sb.append('.');
            }
            sb.append(word);
        }
        return protocol + "://" + sb.toString();
    }
}

